package com.bokesoft.distro.tech.bootsupport.starter.auth.crossauth;

import com.bokesoft.distro.tech.commons.basis.auth.crossauth.CrossAuthTokenSetting;
import com.bokesoft.distro.tech.commons.basis.auth.crossauth.ICrossAuthTokenSettingProvider;
import jodd.util.Wildcard;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class DefaultCrossAuthTokenSettingProvider implements ICrossAuthTokenSettingProvider {

    @Autowired
    private CrossAuthConfig authConfig;

    public DefaultCrossAuthTokenSettingProvider(){}

    @Override
    public CrossAuthTokenSetting getAuthTokenSetting(String callerId) {
        List<CrossAuthConfig.CallerAuthSetting> callerAuthSettings = authConfig.getSettings();
        for(CrossAuthConfig.CallerAuthSetting callerAuthSetting:callerAuthSettings) {
            if(Wildcard.match(callerId, callerAuthSetting.getCallerIdPattern())) {
                return callerAuthSetting.getSetting();
            }
        }
        return null;
    }


}
