package com.bokesoft.distro.tech.bootsupport.starter.api;

import java.util.Map;

import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;

/**
 * 用于在 Yigo 的主要页面实现以 script 标签的方式注入 javascript 变量
 */
public interface YigoClientPageVariableProvider {

    /**
     * 查询支持的页面
     * @param pageBuildContext 当前页面构建上下文
     */
    boolean support(PageBuildContext pageBuildContext);

    /**
     * 获取需要注入的变量
     * @param pageBuildContext 当前页面构建上下文
     * @return Key-变量名、Value-变量值, 以 JSON 对象方式嵌入
     */
    Map<String, Object> getVariables(PageBuildContext pageBuildContext);

}
