/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.yigoconfig.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoBootPreparator;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparationHelper;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.YigoConfigBean;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.SolutionConfig;
import com.bokesoft.yes.mid.event.EventListener;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.event.YigoEventFacade;
import com.bokesoft.yigo.mid.event.types.meta.factory.PrimarySettingPostLoadEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SolutionDataPathConfigurer
implements YigoBootPreparator {
    private static final Logger logger = LoggerFactory.getLogger(SolutionDataPathConfigurer.class);
    private final YigoConfigBean yigoConfig;

    public SolutionDataPathConfigurer(YigoConfigBean yigoConfig) {
        this.yigoConfig = yigoConfig;
    }

    public void prepare(YigoPropPreparationHelper.PrepareResult prepareResult) {
        YigoEventFacade.registerListener((EventListener)new SolutionDataPathInitListener());
    }

    class SolutionDataPathInitListener
    implements EventListener<PrimarySettingPostLoadEvent> {
        SolutionDataPathInitListener() {
        }

        public void handleEvent(PrimarySettingPostLoadEvent event) {
            IMetaFactory metaFactory = event.getMetaFactory();
            try {
                this.setSolutionDataPath(metaFactory, SolutionDataPathConfigurer.this.yigoConfig.getSolution());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        private void setSolutionDataPath(IMetaFactory metaFactory, SolutionConfig solutionConfig) throws Throwable {
            String dataPath;
            if (null != solutionConfig && StringUtils.isNotBlank((CharSequence)(dataPath = solutionConfig.getDataPath()))) {
                metaFactory.getSolution().setDataPath(dataPath);
                if (logger.isInfoEnabled()) {
                    logger.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f: \u5f3a\u5236\u8bbe\u7f6e DataPath='{}' .", (Object)dataPath);
                }
            }
        }
    }
}

