/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.servlet;

import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.server.ServiceRequest;
import com.bokesoft.yes.mid.server.ServiceResponse;
import com.bokesoft.yes.mid.server.dispatcher.ServiceDispatcherFactory;
import com.bokesoft.yes.mid.session.SessionTicketidRecorder;
import com.bokesoft.yes.mid.web.tool.RequestUtil;
import com.bokesoft.yes.tools.zip.GZIPTools;
import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.server.IServiceRequest;
import com.bokesoft.yigo.mid.server.IServiceResponse;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class ServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block9: {
            PrintWriter printWriter = null;
            try {
                object.setCharacterEncoding("UTF-8");
                httpServletResponse.setCharacterEncoding("UTF-8");
                object = this.processService((HttpServletRequest)object, httpServletResponse);
                if (object != null) {
                    httpServletResponse.setContentType("text/plain;charset=UTF-8");
                    printWriter = httpServletResponse.getWriter();
                    printWriter.write(object.toString());
                }
                if (printWriter != null) {
                    printWriter.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject.put("error", (Object)jSONObject2);
                    jSONObject.put("success", false);
                    if (throwable instanceof CoreException) {
                        CoreException coreException = (CoreException)throwable;
                        jSONObject2.put("error_code", coreException.getCode());
                        jSONObject2.put("error_info", (Object)coreException.getMessage());
                    } else {
                        jSONObject2.put("error_code", -1);
                        jSONObject2.put("error_info", (Object)(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage()));
                    }
                    httpServletResponse.setContentType("text/plain;charset=UTF-8");
                    httpServletResponse.getWriter().write(jSONObject.toString());
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (printWriter == null) break block9;
                    printWriter.close();
                }
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected IServiceResponse createResponse() throws Throwable {
        return new ServiceResponse();
    }

    protected void preparedRequest(ServiceRequest serviceRequest, HttpServletRequest object, HttpServletResponse object2) throws Throwable {
        Object object3;
        int n;
        Object object4;
        Object object5;
        object2 = object.getCookies();
        if (object2 != null) {
            object5 = Boolean.FALSE;
            object4 = Boolean.FALSE;
            int n2 = ((Cookie[])object2).length;
            for (n = 0; !(n >= n2 || ((Boolean)object5).booleanValue() && ((Boolean)object4).booleanValue()); ++n) {
                object3 = object2[n];
                if (object3.getName().equalsIgnoreCase("clientID")) {
                    serviceRequest.setClientID(object3.getValue());
                    object5 = Boolean.TRUE;
                    continue;
                }
                if (!object3.getName().equals("locale")) continue;
                int n3 = object3.getValue().indexOf(45);
                serviceRequest.setLanguage(object3.getValue().substring(0, n3));
                serviceRequest.setLocale(object3.getValue());
                object4 = Boolean.TRUE;
            }
        }
        if ((object5 = object.getParameter("yigoData")) != null && !((String)object5).isEmpty()) {
            object4 = Base64.decode((byte[])((String)object5).getBytes());
            String string = GZIPTools.decompress((InputStream)new ByteArrayInputStream((byte[])object4), (String)"UTF-8");
            object3 = new JSONObject(string);
            object4 = object3.keySet().iterator();
            while (object4.hasNext()) {
                object5 = object4.next().toString();
                if (object3.isNull((String)object5)) {
                    serviceRequest.putParameter((String)object5, null);
                    continue;
                }
                String string2 = TypeConvertor.toString((Object)object3.get((String)object5));
                serviceRequest.putParameter((String)object5, (Object)string2);
                if (((String)object5).equals("mode")) {
                    serviceRequest.setMode(TypeConvertor.toInteger((Object)string2).intValue());
                    continue;
                }
                if (((String)object5).equals("language")) {
                    serviceRequest.setLanguage(string2);
                    continue;
                }
                if (!((String)object5).equals("locale")) continue;
                serviceRequest.setLocale(string2);
            }
        }
        object4 = object.getParameterMap().keySet().toArray();
        for (n = 0; n < ((Object[])object4).length; ++n) {
            String string = object4[n].toString();
            if (string.equals("yigoData")) continue;
            object3 = object.getParameter(string);
            serviceRequest.putParameter(string, object3);
            if (string.equals("mode")) {
                serviceRequest.setMode(TypeConvertor.toInteger((Object)object3).intValue());
                continue;
            }
            if (string.equals("language")) {
                serviceRequest.setLanguage((String)object3);
                continue;
            }
            if (!string.equals("locale")) continue;
            serviceRequest.setLocale((String)object3);
        }
        Object object6 = RequestUtil.getIPAddr((HttpServletRequest)object);
        serviceRequest.setIP((String)object6);
        String string = object.getRequestURL().toString();
        int n4 = string.indexOf("//");
        int n5 = string.indexOf("/", n4 + 2);
        object2 = n5 == -1 ? string.substring(n4 + 2) : string.substring(n4 + 2, n5);
        int n6 = ((String)object2).indexOf(58);
        if (n6 == -1) {
            object6 = object2;
            object2 = "80";
        } else {
            object6 = ((String)object2).substring(0, n6);
            object2 = ((String)object2).substring(n6 + 1);
        }
        serviceRequest.setHost((String)object6);
        serviceRequest.setPort((String)object2);
        object2 = object.getContextPath();
        if (((String)object2).startsWith("/")) {
            object2 = ((String)object2).substring(1);
        } else if (((String)object2).isEmpty()) {
            object2 = "yigo";
        }
        serviceRequest.setContextName((String)object2);
        object = object.getHeader("range");
        serviceRequest.putParameter("range", object);
    }

    protected IServiceRequest createRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        ServiceRequest serviceRequest = new ServiceRequest();
        this.preparedRequest(serviceRequest, httpServletRequest, httpServletResponse);
        String string = serviceRequest.getClientID();
        if (string == null || string.isEmpty()) {
            string = UUID.randomUUID().toString();
            Cookie cookie = new Cookie("clientID", string);
            cookie.setHttpOnly(true);
            cookie.setPath(httpServletRequest.getContextPath());
            httpServletResponse.addCookie(cookie);
            serviceRequest.setClientID(string);
        }
        return serviceRequest;
    }

    public Object processService(HttpServletRequest object, HttpServletResponse httpServletResponse) throws Throwable {
        IServiceRequest iServiceRequest = this.createRequest((HttpServletRequest)object, httpServletResponse);
        this.checkTicketID(iServiceRequest, (HttpServletRequest)object);
        object = ServiceDispatcherFactory.getInstance().create(iServiceRequest);
        IServiceResponse iServiceResponse = this.createResponse();
        object.processService(iServiceRequest, iServiceResponse);
        object = iServiceResponse.getResult();
        this.dealTicketID(iServiceRequest, httpServletResponse);
        this.createNewClientID(iServiceRequest, httpServletResponse);
        if (iServiceResponse.hasErr()) {
            throw iServiceResponse.getException();
        }
        return object;
    }

    private void dealTicketID(IServiceRequest iServiceRequest, HttpServletResponse httpServletResponse) {
        String string = iServiceRequest.getClientID();
        int n = iServiceRequest.getMode();
        ServerSetting serverSetting = ServerSetting.getInstance();
        if (serverSetting.containsValidateLevel(2) || serverSetting.containsValidateLevel(6)) {
            n = SessionTicketidRecorder.update((String)string, (int)n);
            httpServletResponse.setHeader("ticketid", String.valueOf(n));
        }
    }

    private void createNewClientID(IServiceRequest iServiceRequest, HttpServletResponse httpServletResponse) {
        long l;
        long l2;
        ISessionInfoProvider iSessionInfoProvider;
        String string = iServiceRequest.getClientID();
        int n = iServiceRequest.getMode();
        Long l3 = ServerSetting.getInstance().getSessionKeepTime();
        if (l3 > 0L && (iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)n)) != null && (string = iSessionInfoProvider.getSessionInfoMap().get(string)) != null && string.getType() == 1 && (l2 = new Date().getTime()) - (l = string.getCreateTime().getTime()) >= l3 * 1000L && string != null && string instanceof SessionInfo) {
            l3 = (SessionInfo)string;
            String string2 = UUID.randomUUID().toString();
            l3.setClientID(string2);
            iSessionInfoProvider.getSessionInfoMap().put(string2, (ISessionInfo)string);
            httpServletResponse.setHeader("newClientID", string2);
        }
    }

    private void checkTicketID(IServiceRequest iServiceRequest, HttpServletRequest httpServletRequest) throws Throwable {
        int n;
        int n2;
        if (iServiceRequest == null) {
            return;
        }
        String string = iServiceRequest.getClientID();
        int n3 = iServiceRequest.getMode();
        ServerSetting serverSetting = ServerSetting.getInstance();
        if ((serverSetting.containsValidateLevel(2) || serverSetting.containsValidateLevel(6)) && (n2 = SessionTicketidRecorder.getTicketID((String)string, (int)n3)) != (n = TypeConvertor.toInteger((Object)httpServletRequest.getHeader("ticketid")).intValue())) {
            ISessionInfoProvider iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)n3);
            if (iSessionInfoProvider != null) {
                iSessionInfoProvider.getSessionInfoMap().remove(string);
            }
            throw new SessionException(12, SessionException.formatMessage(null, (int)12, (Object[])new Object[0]));
        }
    }
}

