package com.bokesoft.yigo.mid.web.util;

import java.io.ByteArrayOutputStream;
import java.util.LinkedList;

import com.bokesoft.yes.mid.web.util.PrintPDF;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
/**
 * 外部使用的平台打印工具类
 * @author 陈瑞
 *
 */
public class PdfPrinter {
	/** 表单标识*/
	private String formKey;
	/** 打印元数据对象*/
	private MetaReport metaReport;
	/** 是否套打*/
	private boolean fillEmptyPrint = false;
	
	public PdfPrinter(String formKey, MetaReport metaReport, boolean fillEmptyPrint) {
		this.formKey = formKey;
		this.metaReport = metaReport;
		this.fillEmptyPrint = fillEmptyPrint;
	}

	/**
	 * 打印单个文档
	 * @param context 上下文
	 * @param doc 文档
	 * @return pdf输出流
	 * @throws Throwable
	 */
	public ByteArrayOutputStream printPDF(DefaultContext context, Document doc) throws Throwable {
		return new PrintPDF(formKey, metaReport, fillEmptyPrint).printPDF(context, doc, null);
	}
	
	/**
	 * 批量打印文档
	 * @param context 上下文
	 * @param OIDs OID集合
	 * @return pdf输出流
	 * @throws Throwable
	 */
	public ByteArrayOutputStream batchPrintPdf(DefaultContext context,LinkedList<Long> OIDs) throws Throwable {
		return new PrintPDF(formKey, metaReport, fillEmptyPrint).batchPrintPdf(context, OIDs);
	}
}
