package com.bokesoft.yes.mid.web.ui.load.popview;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaPopView;
import com.bokesoft.yigo.tools.ve.VE;

public class PopViewJSONBuilder extends BaseComponentJSONBuilder<MetaPopView> {
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaPopView meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BODY_ROOT, builder.build(ve, builder, metaForm, meta.getRoot()));
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_POPANIM, meta.getPopAnim(), "");
		
		if(meta.getOnClose() != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClose, meta.getOnClose().getContent(), "");
		}
		if(meta.getOnShow() != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnPostShow, meta.getOnShow().getContent(), "");
		}
		
	}

}
