package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDef;
import com.bokesoft.yigo.tools.ve.VE;

public class RowDefJSONBuilder extends AbstractJSONBuilder<MetaRowDef> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaRowDef meta)
			throws Throwable {
		DefSize height = meta.getHeight();
		if (height != null) {
			if (height.getSizeType() == DefSize.Fix) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT,height.getSize(), 0);
			} else if (height.getSizeType() == DefSize.Ratio) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "0");
			} else if (height.getSizeType() == DefSize.Pref) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, DefSize.STR_Pref, "");
			}
		}	
	}
}
