package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import com.bokesoft.yigo.common.def.ExtraLayoutType;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaExtraLayout;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.tools.ve.VE;

public class GridLayoutPanelJSONBuilder extends BasePanelJSONBuilder<MetaGridLayoutPanel> {
	
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaGridLayoutPanel meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_GRID);

		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ODDCOLUMNCOLOR, meta.getOddColumnColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_FORCELAYOUT, meta.isForceLayout(), true);
		
		MetaGridLayout layoutImpl = meta.newLayout();
		
		// 载入行定义 
		MetaRowDefCollection rowDefCollection = layoutImpl.getRowDefCollection();
		if(rowDefCollection != null){
			JSONObject rowDefCollectionJSON = builder.build(ve, builder, metaForm, rowDefCollection);
			json.put(JSONConstants.GRIDLAYOUTPANEL_HEIGHTS, rowDefCollectionJSON.getJSONArray(JSONConstants.GRIDLAYOUTPANEL_HEIGHTS));
			JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ROWGAP, rowDefCollection.getRowGap(), 0 );
		}

		// 载入列定义
		MetaColumnDefCollection columnDefCollection = layoutImpl.getColumnDefCollection();
		if(columnDefCollection != null){
			JSONObject columnDefCollectionJSON = builder.build(ve, builder, metaForm, columnDefCollection);
			json.put(JSONConstants.GRIDLAYOUTPANEL_WIDTHS, columnDefCollectionJSON.getJSONArray(JSONConstants.GRIDLAYOUTPANEL_WIDTHS));
			json.put(JSONConstants.GRIDLAYOUTPANEL_MINWIDTHS, columnDefCollectionJSON.getJSONArray(JSONConstants.GRIDLAYOUTPANEL_MINWIDTHS));
			JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_COLUMNGAP, columnDefCollection.getColumnGap(), 0 );
		}
		//ExtraLayout
		MetaExtraLayout metaExtraLayout = meta.getMetaExtraLayout();
		if (metaExtraLayout != null){
			JSONObject build = builder.build(ve, builder, metaForm, metaExtraLayout);
			build.put(JSONConstants.GRIDLAYOUTPANEL_EXTRA_LAYOUT_TYPE, ExtraLayoutType.toString(metaExtraLayout.getType()));
			json.put(JSONConstants.GRIDLAYOUTPANEL_EXTRA_LAYOUT, build);

		}
		int componentCount = meta.getComponentCount();
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		for ( int i = 0; i<componentCount; ++i ) {
			metaComponent = meta.getComponent(i);
			if(metaComponent.getControlType() == ControlType.FRAME){
				continue;
			}
			JSONObject childJSON = builder.build(ve, builder, metaForm, metaComponent);
			MetaLayoutSpan layoutItem = layoutImpl.get(metaComponent.getKey());
			if(layoutItem != null) {
				childJSON.put(JSONConstants.COMMON_X, layoutItem.getX());
				childJSON.put(JSONConstants.COMMON_Y, layoutItem.getY());
				childJSON.put(JSONConstants.COMMON_COLSPAN, layoutItem.getXSpan());
				childJSON.put(JSONConstants.COMMON_ROWSPAN, layoutItem.getYSpan());
				items.put(childJSON);
			}
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}

}
