package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaExtraLayout;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGroup;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGroupCollection;
import com.bokesoft.yigo.tools.ve.VE;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 *文件名: ExtraLayoutJSONBuilder
 *创建者: zhangk
 *创建时间:2022/9/13 14:27
 */
public class ExtraLayoutJSONBuilder extends AbstractJSONBuilder<MetaExtraLayout> {
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaExtraLayout meta) throws Throwable {
		MetaGroupCollection metaGroupCollection = meta.getMetaGroupCollection();
		JSONArray items = new JSONArray();
		if (metaGroupCollection != null) {
			if (metaGroupCollection.size() > 0) {
				for (MetaGroup metaGroup : metaGroupCollection) {
					JSONObject build1 = builder.build(ve, builder, metaForm, metaGroup);
					items.put(build1);
				}
			}
		}
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_COLLECTION, items);
	}
}
