package com.bokesoft.yes.mid.web.ui.load.control.properties;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSplitButtonProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class SplitButtonPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaSplitButtonProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaSplitButtonProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SPLITBUTTON_ICON, meta.getIcon(), "");

		MetaDropdownItemCollection dropdownItemCollectionMeta = meta.getItemCollection();
		Iterator<MetaDropdownItem> itDropdownItem = dropdownItemCollectionMeta.iterator();
		MetaDropdownItem metaDropdownItem = null;
		JSONObject item = null;
		JSONArray items = new JSONArray();
		String text = null;
		while(itDropdownItem.hasNext()){
			metaDropdownItem = itDropdownItem.next();
			item = new JSONObject();
			JSONHelper.writeToJSON(item, JSONConstants.DROPDOWNITEM_KEY, metaDropdownItem.getKey(), "");
			
			text = builder.getString(GroupKeyTable.STR_ITEMS, key, "Item-"+metaDropdownItem.getKey(), metaDropdownItem.getText());
			JSONHelper.writeToJSON(item, JSONConstants.DROPDOWNITEM_TEXT, text, "");
			JSONHelper.writeToJSON(item, JSONConstants.DROPDOWNITEM_SEPARATOR, metaDropdownItem.getSeparator(), false);
			MetaBaseScript onClickExp = metaDropdownItem.getOnClick();
			if(onClickExp != null) {
				item.put("formula", onClickExp.getContent().trim());
			}
			items.put(item);
		}
		json.put("dropdownItems", items);
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent(), "");
		}
	}
}
