package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class HyperLinkPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaHyperLinkProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaHyperLinkProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_URL,  meta.getURL(), "");
		JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_TARGETSHOWTYPE,  meta.getTargetShowType(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_FORMULAURL,  meta.getFormulaURL(), "");
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent(), "");
		}
	}
}

