package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class DynamicDictPropertiesJSONBuilder extends DictPropertiesJSONBuilder {
	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaDictProperties meta, String key) throws Throwable {
		super.loadImpl(ve, builder, json, metaForm, meta, key);
		
		//动态字典
		String refKey = meta.getRefKey();
		if( refKey != null && !refKey.isEmpty() ) {
			json.put(JSONConstants.DICT_REFKEY, refKey);
			builder.addRelation(key, refKey);
		}
	}
}
