package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDateRangePickerProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class DateRangePickerPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaDateRangePickerProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaDateRangePickerProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_FORMATSTR, meta.getDateFormat(), "yyyy-MM-dd HH:mm:ss");
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_MINTIME, meta.getMinTime(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_MAXTIME, meta.getMaxTime(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_LINKSTYLE, meta.getLinkStyle(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_ISONLYDATE, meta.isOnlyDate(), false);
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_POP);
	}
}

