package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class ButtonPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaButtonProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaButtonProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICON,  meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICONLOCATION,  
				IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ONLYICON,  meta.isOnlyIcon(), false);
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_UPLOADTYPE,  meta.getUploadType(), "");
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent(), "");
		}

	}
}

