package com.bokesoft.yes.mid.web.ui.load.control.listview.extend;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.ListViewJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotatorList;
import com.bokesoft.yigo.tools.ve.VE;

public class RotatorListJSONBuilder extends ListViewJSONBuilder{
	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaListView meta) throws Throwable {
		MetaRotatorList metaRotatorList = (MetaRotatorList) meta;
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATORLIST_ROWCOUNT, metaRotatorList.getRowCount(), MetaRotatorList.ROTATORLIST_DEFAULT_ROWCOUNT);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATORLIST_COLUMNCOUNT, metaRotatorList.getColumnCount(), MetaRotatorList.ROTATORLIST_DEFAULT_COLUMNCOUNT);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATORLIST_ROWGAP, metaRotatorList.getRowGap(), 0);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATORLIST_CELLGAP, metaRotatorList.getCellGap(), 0);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INDICATOR, metaRotatorList.isIndicator(), true);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INDICATORLOCATION, metaRotatorList.getIndicatorLocation(), -1);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_PAGINATION, metaRotatorList.isPagination(), false);
		if(metaRotatorList.getMoreItem() != null && !metaRotatorList.getMoreItem().isEmpty()){
			metaJSON.put(JSONConstants.ROTATORLIST_MOREITEM, metaRotatorList.getMoreItem().getContent());	
			metaJSON.put(JSONConstants.ROTATORLIST_MOREITEM_ICON, metaRotatorList.getMoreItem().getIcon());
		}
		return metaJSON;
	}
}
