package com.bokesoft.yes.mid.web.ui.load.control.listview.extend;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.ListViewJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaGallery;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.tools.ve.VE;

public class GalleryJSONBuilder extends ListViewJSONBuilder {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaListView meta) throws Throwable {
		MetaGallery metaGallery = (MetaGallery)meta;
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.GALLERY_REPEAT, metaGallery.isRepeat(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATORLIST_CELLGAP, metaGallery.getCellGap(), 0);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INDICATOR, metaGallery.isIndicator(), true);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_INDICATORLOCATION, metaGallery.getIndicatorLocation(), -1);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.ROTATER_PAGINATION, metaGallery.isPagination(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.GALLERY_DISPLAYRATIO, metaGallery.getDisplayRatio()+"", 1f+"");
		return metaJSON;
	}
}
