package com.bokesoft.yes.mid.web.ui.load.control.listview;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewRow;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class ListViewRowJSONBuilder extends AbstractJSONBuilder<MetaListViewRow> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaListViewRow meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATORSTYLE, meta.getSeparatorStyle(), "");
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATORCOLOR, meta.getSeparatorColor(), "");
		if(meta.getSeparatorOffset() != null){
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATOROFFSET, meta.getSeparatorOffset().toString(), "");
		}
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SELECTCOLOR, meta.getSelectColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_HIGHLIGHTCOLOR, meta.getHighlightColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_BACKCOLOR, meta.getBackColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_TOPMARGIN, meta.getTopMargin(), "");
		JSONArray actions = new JSONArray();
		MetaRowActionCollection collection = meta.getActionCollection();
		if( collection != null ) {
			for (int i = 0; i < meta.getActionCollection().size(); i++) {
				MetaRowAction metaRowAction = meta.getActionCollection().get(i);
				JSONObject actionObject = new JSONObject();
				actionObject.put(JSONConstants.COMMON_KEY, metaRowAction.getKey());
				actionObject.put(JSONConstants.COMMON_CAPTION, metaRowAction.getCaption());
				actionObject.put(JSONConstants.LISTVIEW_ROW_ACTION_CONTENT, metaRowAction.getContent());
				actions.put(actionObject);
			}
			json.put(JSONConstants.LISTVIEW_ROW_ACTION_COLLECTION, actions);			
		}
	}

}
