package com.bokesoft.yes.mid.web.ui.load.control.listlayoutview;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayout;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.tools.ve.VE;

public class RowLayoutJSONBuilder extends AbstractJSONBuilder<MetaRowLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm,
			MetaRowLayout meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption(), "");
		
		
		JSONObject layoutJSON = null;
		MetaPanel layout = meta.getLayout();
		if(layout != null) {			
			layoutJSON = builder.build(ve, builder, metaForm, layout);
			json.put("layout", layoutJSON);
		}
	}

}
