package com.bokesoft.yes.mid.web.ui.load.control.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDynamicProperties;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.PropertiesJSONBuilderMap;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yes.tools.json.JSONUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.IMetaGridRowObject;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOpt;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOptCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCellFormat;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridFilter;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowLayer;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowAreaExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowTree;
import com.bokesoft.yigo.meta.form.component.grid.MetaTrace;
import com.bokesoft.yigo.meta.form.component.grid.MetaTraceCollection;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class GridJSONBuilder extends BaseComponentJSONBuilder<MetaGrid> {
	
	public GridJSONBuilder(){

	}
	
	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaGrid meta) throws Throwable {
		JSONObject json = super.getMetaJSON(ve, builder, metaForm, meta);
		
		// 表格自身数据依赖
		builder.addRelations(meta.getKey(), new ArrayList<String>(meta.getOwnerDepFields()));
		
		// metarow to json
		JSONArray metaRowArray = new JSONArray();
		MetaGridRowCollection rowCollection = meta.getRowCollection();
		for (MetaGridRow metaRow : rowCollection) {
			metaRowArray.put(toMetaRowJSON(ve, builder, metaForm, meta.getKey(),metaRow));
		}
		json.put("rows", metaRowArray);
		
		// 行区域拓展
		MetaRowAreaExpand areaExpand = meta.getRowAreaExpand();
		if( areaExpand != null ) {
			//json.put("areaExpand", areaExpand.toJSON());
		}
		
		// metacolumn to json
		JSONArray metaColArray = new JSONArray();
		for(MetaGridColumn metaColumn : meta.getColumnCollection()){
			metaColArray.put(builder.build(ve, builder, metaForm, metaColumn));
		}
		json.put("columns", metaColArray);
		
		// metaGroupCell to json
		json.put("groupIndexes", meta.getGroupIndexes());	
		json.put("mergeCellKeys", meta.getMergeCells());
		json.put("tableKeys", meta.getTableKeys());
		
		json.put("pageLoadType", meta.getPageLoadType());
		json.put("pageRowCount", meta.getPageRowCount());
		json.put("pageIndicatorCount", meta.getPageIndicatorCount());
		
		json.put("freezeRowCnt", meta.getFreezeRowCount());
		json.put("freezeColCnt", meta.getFreezeColumnCount());
		
		JSONArray rowList = new JSONArray();
		String rowRange = meta.getRowRange();
		if( rowRange != null && !rowRange.isEmpty() ) {
			String[] arr = rowRange.split(",");
			for( int i = 0,length = arr.length;i < length;i++ ) {
				rowList.put(Integer.parseInt(arr[i].trim()));
			}
		}
		
		json.put("rowList", rowList);
		if( rowList.length() > 0 ) {
			json.put("pageRowCount", rowList.optInt(0));
		}
		
		//行单击事件
		MetaBaseScript rowClick = meta.getRowClick();
		if(rowClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent(), "");
		}
		
		//行切换事件
		MetaBaseScript focusRowChanged = meta.getFocusRowChanged();
		if(focusRowChanged != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, focusRowChanged.getContent(), "");
		}
		
		//行双击事件
		MetaBaseScript rowDbClick = meta.getRowDblClick();
		if(rowDbClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, rowDbClick.getContent(), "");
		}
		
		//行增加事件
		MetaBaseScript rowInsert = meta.getRowInsert();
		if( rowInsert != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowInsert, rowInsert.getContent(), "");
		}
		
		//行删除后事件
		MetaBaseScript rowDelete = meta.getRowDelete();
		if( rowDelete != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDelete, rowDelete.getContent(), "");
		}
		
		//行删除事件
		MetaBaseScript onRowDelete = meta.getOnRowDelete();
		if( onRowDelete != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnRowDelete, onRowDelete.getContent(), "");
		}
		
		JSONObject leafIndexMapObj = new JSONObject();
		Map<String, Integer> map = meta.getLeafIndexMap();
		Iterator<String> it = map.keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			leafIndexMapObj.put(key, map.get(key));
		}
		json.put("leafIndexMap", leafIndexMapObj);
				
		json.put("hideGroup4Editing", meta.isHideGroup4Editing());

		json.put("rowLayer", initRowLayer(meta));
		
		json.put("add", meta.canInsert());
		json.put("gridsort", meta.getGridDefaultSortField());
		json.put("del", meta.canDelete());
		json.put("shift", meta.canShift());
		json.put("frozenRow", meta.canFrozenRow());
		json.put("frozenColumn", meta.canFrozenColumn());
		json.put("bestWidth", meta.getBestWidth());
		json.put("editRowFormKey", meta.getEditRowFormKey());
		
		json.put("detailMetaRowIndex", meta.getDetailMetaRowIndex());
		
		json.put("selectionMode", meta.getSelectMode());
		
		json.put("serialSeq", meta.isSerialSeq());
		
		json.put("serialRowNum", meta.isSerialRowNum());
		
		return json;
	}
	
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaGrid meta) throws Throwable {

		super.load(ve, builder, json, metaForm, meta);
		
		json.put("defaultLayer", meta.getDefaultLayer());
		json.put("gridsort", meta.getGridDefaultSortField());
		json.put("hasColExpand", meta.hasColumnExpand());
		json.put("hasCellExpand", meta.hasCellExpand());
		json.put("hasRowExpand", meta.hasRowExpand());
		json.put("hasRowAreaExpand", meta.hasRowAreaExpand());
		json.put("hasGroupRow", meta.hasRowGroup());
		json.put("hasFixRow", meta.hasFixRow());
		json.put("hasTotalRow", meta.hasTotalRow());
		json.put("hasFixCellMerge", meta.hasFixCellMerge());
		json.put("hasDetailRow", meta.hasDetailRow());
		json.put("hasDetailCellMerge", meta.hasDetailCellMerge());
		json.put("hasSubDetail", meta.hasSubDetail());
		json.put("hasTree", meta.hasTree());
		
		json.put("showRowHead", meta.isShowRowHead());
		json.put("endEditByNav", meta.isEndEditByNav());
		json.put("hideGroup4Editing", meta.isHideGroup4Editing());
		json.put("multiple", meta.isMultiple());
		
		json.put("newEmptyRow", meta.getNewEmptyRow());
		json.put("singleSelect", meta.singleSelect());
		json.put("selectFieldIndex", meta.getSelectIndex());
		json.put("treeIndex", meta.getTreeIndex());
		
		MetaGridRow detailRow = meta.getDetailMetaRow();
		MetaRowTree rowTree = detailRow != null ? detailRow.getRowTree() : null;
		
		json.put("treeType", rowTree == null ? -1 : rowTree.getTreeType());
		json.put("treeExpand", rowTree == null ? false : rowTree.isExpand());
		
		json.put("rowExpandIndex", meta.getRowExpandIndex());

		json.put("topFixRowCount", meta.getTopFixRowCount());
		json.put("bottomFixRowCount", meta.getBottomFixRowCount());
		
		json.put("primaryKeys", MetaUtil.getPrimaryKeys(ve.getMetaFactory(),metaForm, meta.getTableKey()));
		json.put("editRowFormKey", meta.getEditRowFormKey());
		
		MetaGridFilter filter = meta.getFilter();
		if( filter != null ) {
			//json.put("filter", filter.toJSON());			
		}
		
		MetaTraceCollection tcs = meta.getTraceCollection();
		if( tcs != null ) {
			JSONArray traces = new JSONArray();
			for( MetaTrace trace : tcs ) {
			//	traces.put(trace.toJSON());
			}
			json.put("traces", traces);
		}
		
		MetaExtOptCollection eoc = meta.getExtOpts();
		if( eoc != null ) {
			JSONArray opts = new JSONArray();
			for( MetaExtOpt opt : eoc ) {
			//	opts.put(opt.toJSON());
			}
			json.put("extOpts", opts);
		}
		
		String option = meta.getOption();
		if( option != null && !option.isEmpty() ){
			String[] options = option.split(",");
			JSONArray array = new JSONArray();
			for( String opt : options ) {
				array.put(opt);
			}
			json.put("opts", array);
		}
	}

	private JSONObject initRowLayer(MetaGrid metaGrid) {
		JSONObject rowLayerObj = new JSONObject();
		MetaGridRowLayer rowLayer = metaGrid.getRowLayer();
		JSONArray array = new JSONArray();
		for (int i = 0,size = rowLayer.getObjectCount();i < size; i++) {
			array.put(rowObj2JSON(metaGrid, rowLayer.getObject(i)));
		}
		rowLayerObj.put("areaIndex", rowLayer.getAreaIndex());
		return rowLayerObj.put("objectArray", array);
	}
	
	private JSONObject rowObj2JSON(MetaGrid metaGrid, IMetaGridRowObject rowObj) {
		JSONObject json = new JSONObject();
		int objectType = rowObj.getObjectType();
		json.put("objectType", objectType);
		if( objectType == IMetaGridRowObject.Row ) {
			return json.put("rowIndex", metaGrid.getRowCollection().indexOf((MetaGridRow) rowObj));
		}
		JSONArray array = new JSONArray();
		for (int i = 0,size = rowObj.getObjectCount(); i < size; i++) {
			array.put(rowObj2JSON(metaGrid, rowObj.getObject(i)));
		}
		return json.put("objectArray", array);
	}

	private JSONObject toMetaRowJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, String key,MetaGridRow metaRow) throws Throwable {
		JSONObject metaObj = new JSONObject();
		metaObj.put("key", metaRow.getKey());
		metaObj.put("objectType", metaRow.getObjectType());
		metaObj.put("rowType", RowType.toString(metaRow.getRowType()));
		
		int rowHeight = metaRow.getRowHeight();
		if( rowHeight != MetaGridRow.DEFAULT_HEIGHT ) {
			metaObj.put("rowHeight", rowHeight);			
		}
		
		metaObj.put("isGroupHead", metaRow.isGroupHead());
		metaObj.put("isGroupTail", metaRow.isGroupTail());
		
		metaObj.put("areaIndex", metaRow.getAreaIndex());
		
		metaObj.put("isDetailHead", metaRow.isDetailHead());
		metaObj.put("isDetailTail", metaRow.isDetailTail());
		metaObj.put("detailIndex", metaRow.getDetailIndex());
		
		metaObj.put("linkType", metaRow.getLinkType());
		metaObj.put("backColor", metaRow.getBackColor());
		
		metaObj.put("targetFields",JSONUtil.toJSONArray(metaRow.getTargetFields()));
		metaObj.put("sourceFields",JSONUtil.toJSONArray(metaRow.getSourceFields()));
		
		MultiDimValue dimValue = null;
		
		MetaTable metaTable = null;
		MetaColumn metaColumn = null;
		
		if( metaRow.getRowType() == RowType.Detail ) {
			MetaRowExpand rowExpand = metaRow.getRowExpand(); // 行拓展
			if( rowExpand != null ) {
				//metaObj.put("rowExpand", rowExpand.toJSON());
			}
			MetaRowTree rowTree = metaRow.getRowTree(); // 树
			if( rowTree != null ) {
				//metaObj.put("rowTree", rowTree.toJSON());
			}
			dimValue = metaRow.getDimValue(); // 维度数据
			if( dimValue != null ) {
				metaObj.put("dimValue", dimValue.toJSONArray());
			}
			
			metaTable = MetaUtil.getBindingMetaTable(ve.getMetaFactory(), metaForm, metaRow.getTableKey());
		}
		
		JSONArray cellArray = new JSONArray();
		JSONArray cellKeys = new JSONArray();
		MetaGridCell metaCell = null;
		MetaGridCellFormat format = null;
		String tableKey = "";
		String columnKey = "";
				
		for (int i = 0,size = metaRow.size(); i < size; i++) {
			metaCell = metaRow.get(i);
			JSONObject json = new JSONObject();
			json.put("key", metaCell.getKey());
			json.put("caption", MetaUtil.getFormLocaleString(ve.getMetaFactory(),ve.getEnv().getLocale(), metaForm.getKey(),
					GroupKeyTable.STR_CELL, metaCell.getKey(), metaCell.getCaption()));
			json.put("cellType", metaCell.getCellType());
			
			tableKey = metaCell.getTableKey();
			columnKey = metaCell.getColumnKey();
			
			json.put("tableKey", tableKey);
			json.put("columnKey", columnKey);
			
			// accessControl提前设置好
			if( metaCell.hasDataBinding() ) {
				if( metaRow.getRowType() != RowType.Detail ) {
					metaTable = MetaUtil.getBindingMetaTable(ve.getMetaFactory(), metaForm, tableKey);
				}
				metaColumn = metaTable.get(columnKey);
				if (metaColumn != null) {
					json.put("accessControl", metaColumn.isAccessControl());
				}
			}
			
			json.put("valueChanged", metaCell.getValueChanged());
			json.put("valueChangeAction", metaCell.getValueChangeAction());
			json.put("defaultValue", metaCell.getDefaultValue());
			json.put("defaultFormulaValue", metaCell.getDefaultFormulaValue());
			json.put("isSelect", metaCell.isSelect());
			json.put("singleSelect", metaCell.singleSelect());
			json.put("tip", metaCell.getToolTip());
			// 维度数据
			dimValue = metaCell.getDimValue();
			if( dimValue != null ) {
				json.put("dimValue", dimValue.toJSONArray());
			}
			
			// 双击事件
			MetaBaseScript dblClick = metaCell.getDblClick();
			if( dblClick != null && !dblClick.isEmpty() ) {
				json.put("cellDblClick", dblClick.getContent());
			}
			
			// 单元格拓展
			MetaColumnExpand columnExpand = metaCell.getColumnExpand();
			if (columnExpand != null) {
				//json.put("columnExpand", columnExpand.toJSON());
			}
			
			// 合并信息
			json.put("isMerged", metaCell.isMerged());
			json.put("isMergedHead", metaCell.isMergedHead());
			json.put("rowspan", metaCell.getMergedRowSpan());
			json.put("colspan", metaCell.getMergedColumnSpan());
			
			// 边框
			format = metaCell.getFormat();
			if( format != null ) {
				JSONHelper.writeToJSON(json, "topBorder", format.isTopBorder(), false);
				JSONHelper.writeToJSON(json, "rightBorder", format.isRightBorder(), false);
				JSONHelper.writeToJSON(json, "bottomBorder", format.isBottomBorder(), false);
				JSONHelper.writeToJSON(json, "leftBorder", format.isLeftBorder(), false);
			}
			
			initEditOption(ve, builder, metaForm, json, metaCell);
			
			cellArray.put(json);
			cellKeys.put(metaCell.getKey());
		}
		metaObj.put("cells", cellArray);
		metaObj.put("cellKeys", cellKeys);
		return metaObj;
	}

	private void initEditOption(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, JSONObject cellObj, MetaGridCell metaCell) throws Throwable {
		JSONHelper.writeToJSON(cellObj, "hasDB", metaCell.hasDataBinding(), false);
		JSONHelper.writeToJSON(cellObj, "columnKey", metaCell.getColumnKey(), "");
		JSONHelper.writeToJSON(cellObj, "tableKey", metaCell.getTableKey(), "");
		JSONHelper.writeToJSON(cellObj, "backColor", metaCell.getBackColor(), "");
		JSONHelper.writeToJSON(cellObj, "foreColor", metaCell.getForeColor(), "");
		JSONHelper.writeToJSON(cellObj, "isRequired", metaCell.isRequired(), false);
		JSONHelper.writeToJSON(cellObj, "enable", metaCell.getEnable(), "");
		JSONHelper.writeToJSON(cellObj, "merge", metaCell.isMerge(), false);
		JSONHelper.writeToJSON(cellObj, "mergeGroup", metaCell.isMergeGroup(), false);
		PropertiesJSONBuilder<AbstractMetaObject> propertesbuilder = null;
		
		JSONObject options = new JSONObject();
		propertesbuilder = PropertiesJSONBuilderMap.getBuilder(metaCell.getCellType());
		if(propertesbuilder != null) {
			propertesbuilder.load(ve, builder, options, metaForm, metaCell.getProperties(), metaCell.getKey());
		}
		
		options.put("key", metaCell.getKey());
		options.put("cellType", metaCell.getCellType());
		
		cellObj.put("editOptions", options);
		
		switch (metaCell.getCellType()) {
		case ControlType.CHECKBOX:
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "checkbox", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.TEXTAREA:
			JSONHelper.writeToJSON(cellObj, "formatter", "textarea", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.BUTTON:
			// 默认居中,format定义再覆盖
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "button", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);		
			break;
		case ControlType.HYPERLINK:
			// 按照format定义
//			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "hyperlink", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.IMAGE:
		case ControlType.ICON:
		case ControlType.IMAGELIST:
			JSONHelper.writeToJSON(cellObj, "align", "center", "");
			JSONHelper.writeToJSON(cellObj, "formatter", "image", "");
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		case ControlType.DYNAMIC:
			MetaDynamicProperties dynamicPro = (MetaDynamicProperties) metaCell.getProperties();
			options.put("typeFormula", dynamicPro.getTypeFormula());
			options.put("dependency", dynamicPro.getTypeDependency());
			cellObj.put("editOptions", options);
			break;
		case ControlType.UPLOADBUTTON:
		case ControlType.LABEL:
			JSONHelper.writeToJSON(cellObj, "isAlwaysShow", true, false);
			break;
		default:
			break;
		}
		
		// 如果有定义位置,以定义的为准
		MetaGridCellFormat format = metaCell.getFormat();
		if (format != null) {
			JSONHelper.writeToJSON(cellObj, "align", HAlignment.toString(format.getHAlign()), "");
		}
	}

}