package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshFooter;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshHeader;
import com.bokesoft.yigo.tools.ve.VE;

public class RefreshControlJSONBuilder extends BaseComponentJSONBuilder<MetaRefreshControl>{
	
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaRefreshControl meta) throws Throwable {
		// TODO Auto-generated method stub
		super.load(ve, builder, json, metaForm, meta);
		JSONObject metaObj = json.getJSONObject(JSONConstants.COMMON_METAOBJ);
		MetaRefreshHeader rh = meta.getHeader();
		MetaRefreshFooter rf = meta.getFooter();
		if(rh!=null){
			JSONHelper.writeToJSON(metaObj, JSONConstants.REFRESHCONTROL_HEADERREFRESHSCRIPT, rh.getContent(),"");
		}
		if(rf!=null){
			JSONHelper.writeToJSON(metaObj, JSONConstants.REFRESHCONTROL_FOOTERREFRESHSCRIPT, rf.getContent(),"");
		}
//		JSONHelper.writeToJSON(metaObj, propertyName, value, defaultValue);
		JSONObject rootObject = builder.build(ve, builder, metaForm, meta.getRootComp());
		JSONArray items = new JSONArray();
		items.put(rootObject);
		json.put(JSONConstants.COMMON_ITEMS, items);
	}

}
