package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.NavigationListSource;
import com.bokesoft.yigo.common.def.NavigationListStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationItem;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationList;
import com.bokesoft.yigo.tools.ve.VE;

public class NavigationListJSONBuilder extends AbstractJSONBuilder<MetaNavigationList>{

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaNavigationList meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_STYLE, meta.getStyle(), NavigationListStyle.TiledList);
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_SOURCE, meta.getSource(), NavigationListSource.Self);
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ENTRYPATH, meta.getEntryPath(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ALLENTRYFILTER, meta.isAllEntryFilter(), true);
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_COLUMNCOUNT, meta.getColumnCount(), 3);
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_IMAGESCALETYPE, meta.getImageScaleType(), ImageScaleType.CENTER);
		if(meta.getItemCollection() != null){
			JSONArray items = new JSONArray();
			for(int i=0;i<meta.getItemCollection().size();i++){
				MetaNavigationItem item = meta.getItemCollection().get(i);
//				items.put(item.toJSON());
			}
			json.put(JSONConstants.COMBOBOX_ITEMS, items);
		}
//		json.put(JSONConstants.NAVIGATIONLIST_LISTROW, meta.getListRow().toJSON());
	}
}
