package com.bokesoft.yes.mid.web.ui.load;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public abstract class BaseComponentJSONBuilder<T extends MetaComponent> extends AbstractJSONBuilder<T> {

	protected BasePropertiesJSONBuilder<AbstractMetaObject> propertiesJSONBuilder = null;

	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, T meta) throws Throwable{
		JSONObject metaCompJSON = new JSONObject();
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.BASECONTROL_REQUIRED, meta.isRequired(), false);
		//2017.08.31.gmf,enable&visible is used in mobile h5 solution.
		//TableView need these props.
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_ENABLE, meta.getEnable().trim(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_VISIBLE, meta.getVisible().trim(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_CHECKRULE, meta.getCheckRule().trim(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_VALUECHANGED, meta.getValueChanged().trim(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_VALUECHANGEACTION, meta.getValueChangeAction().trim(), "");
		MetaDataBinding dataBinding = meta.getDataBinding();
		if ( dataBinding != null ) {
			JSONObject dataBindingJSON = new JSONObject();
			
			String tableKey = dataBinding.getTableKey();
			String columnKey = dataBinding.getColumnKey();
			
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_TABLEKEY, tableKey, "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_COLUMNKEY, columnKey, "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_REQUIRED, dataBinding.isRequired(), false);
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUECHANGING, dataBinding.getValueChanging(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUECHANGED, dataBinding.getValueChanged(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUECHANGEACTION, dataBinding.getValueChangeAction(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_DEFAULTVALUE,dataBinding.getDefaultValue() , "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_DEFAULTFORMULAVALUE, dataBinding.getDefaultFormulaValue(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUEDEPENDENCY, dataBinding.getValueDependency(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_CHECKRULE, dataBinding.getCheckRule(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_CHECKDEPENDENCY, dataBinding.getCheckDependency(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.CHECKRULE_ERRORINFO, dataBinding.getErrorInfo(), "");
			JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.CHECKRULE_ERRORSTRINGID, dataBinding.getErrorStringID(), "");
			
			MetaBaseScript valueValidation = dataBinding.getValueValidation();
			if(valueValidation != null) {
				JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_VALIDATION, valueValidation.getContent().trim(), "");
				JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUEVALIDATION, valueValidation.getContent().trim(), "");
			}
			MetaBaseScript valueChanged = dataBinding.getValueChangedNode();
			if(valueChanged != null) {
				JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUECHANGED, valueChanged.getContent().trim(), "");
			}

			MetaBaseScript valueChangeActionNode = dataBinding.getValueChangeActionNode();
			if (valueChangeActionNode != null) {
				JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUECHANGEACTION, valueChangeActionNode.getContent().trim(), "");
			}

			MetaBaseScript valueChanging = dataBinding.getValueChangingNode();
			if(valueChanging != null) {
				JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_VALUECHANGING, valueChanging.getContent().trim(), "");
			}
			MetaBaseScript textChanged = dataBinding.getTextChangedNode();
			if(textChanged != null) {
				JSONHelper.writeToJSON(dataBindingJSON, JSONConstants.DATABINDING_TEXTCHANGED, textChanged.getContent().trim(), "");
			}
			
			// 访问控制
			if( tableKey != null && !tableKey.isEmpty() && columnKey != null && !columnKey.isEmpty() ) {
				MetaTable metaTable = MetaUtil.getBindingMetaTable(ve.getMetaFactory(), metaForm, dataBinding.getTableKey());
				MetaColumn metaColumn = metaTable.get(dataBinding.getColumnKey());
				JSONHelper.writeToJSON(metaCompJSON, JSONConstants.ACCESS_CONTROL, metaColumn.isAccessControl(), false);
			}
			
			metaCompJSON.put("dataBinding", dataBindingJSON);
		}
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_VALUECHANGING, meta.getValueChanging().trim(), "");
//		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
//		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");

		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_KEY, meta.getKey(), "");
		String buddyKey = meta.getBuddyKey();
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_BUDDYKEY, buddyKey, "");
		if( buddyKey != null && !buddyKey.isEmpty() ) {
			builder.addBuddyKey(buddyKey);
		}
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_TYPE, meta.getControlType(), -1);
		
		String caption = builder.getString(GroupKeyTable.STR_UI, "", meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_CAPTION, caption, "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_WEIGHT,Math.round(meta.getWeight()),0);
//		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_WEIGHT, meta.getWeight(), 1.0f);
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_COLUMNKEY, meta.getColumnKey(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_TABLEKEY, meta.getTableKey(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_BINDINGCELLKEY, meta.getBindingCellKey(), "");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_ISSUBDETAIL, meta.isSubDetail(), false);
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_PARENTGRIDKEY, meta.getParentGridKey(),"");
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_CLEARABLE, meta.isClearable(), true);
		JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_EXTEND, meta.isExtend(), false);
		
		MetaBaseScript active = meta.getActivate();
		if(active != null) {
			JSONHelper.writeToJSON(metaCompJSON, JSONConstants.COMMON_ACTIVE, active.getContent().trim(), null);
		}
		
		MetaCondition condition = meta.getCondition();
		if(condition != null) {
			JSONObject object = new JSONObject();
			JSONHelper.writeToJSON(object, JSONConstants.COMMON_KEY, meta.getKey(), "");
			JSONHelper.writeToJSON(object, JSONConstants.COMMON_TABLEKEY, condition.getTableKey(), "");
			JSONHelper.writeToJSON(object, JSONConstants.COMMON_COLUMNKEY, condition.getColumnKey(), "");
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_CONDSIGN, condition.getSign(), CondSign.NONE);
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_GROUPHEAD, condition.isGroupHead(), false);
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_GROUPTAIL, condition.isGroupTail(), false);
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_GROUP, condition.getGroup(), "");
			JSONHelper.writeToJSON(object, JSONConstants.COMMON_TYPE, ControlType.parse( meta.getTagName()), -1);
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_LIMITTOSOURCE, condition.isLimitToSource(), false);
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_NEEDRESET, condition.needReset(), true);
			JSONHelper.writeToJSON(object, JSONConstants.CONDITION_LOADHISTORYINPUT, condition.isLoadHistoryInput(), false);
			if (meta.getControlType() == ControlType.LABEL
					|| meta.getControlType() == ControlType.BUTTON
					|| meta.getControlType() == ControlType.CHECKBOX
					|| meta.getControlType() == ControlType.RICHEDITOR
					|| meta.getControlType() == ControlType.PASSWORDEDITOR
					|| meta.getControlType() == ControlType.CHECKLISTBOX
					|| meta.getControlType() == ControlType.TEXTBUTTON
					|| meta.getControlType() == ControlType.RADIOBUTTON || condition.getSign() == 6 || condition.getSign() == -1) {
				JSONHelper.writeToJSON(object, JSONConstants.COMPONENT_USE_ADVANCED_QUERY, false, true);
			} else {
				object.put(JSONConstants.COMPONENT_USE_ADVANCED_QUERY, condition.isUseAdvancedQuery());
			}

			metaCompJSON.put(JSONConstants.COMMON_CONDITION, object);
		}
		
		if ( propertiesJSONBuilder != null && meta.getProperties() != null ) {
			propertiesJSONBuilder.load(ve, builder, metaCompJSON, metaForm, meta.getProperties(), meta.getKey());
		}
		
		// 处理子明细关系
		if(meta.isSubDetail() ||  meta.getControlType() == ControlType.SUBDETAIL){
			String key = null;
			if( meta.getControlType() == ControlType.SUBDETAIL ) {
				key = ((MetaSubDetail)meta).getBindingGridKey();
			} else {
				key = meta.getParentGridKey();
			}
			
			// 添加表格的子明细
			builder.addSubDetail(key, meta.getKey());

			// 添加单元格的子明细
			key = meta.getBindingCellKey();
			if( key != null && !key.isEmpty() ) {
				builder.addSubDetail(key, meta.getKey());				
			} 
		}
		
		return metaCompJSON;
	}

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, T meta)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_X, meta.getX(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_Y, meta.getY(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLSPAN, meta.getXSpan(), 1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROWSPAN, meta.getYSpan(), 1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORECOLOR, meta.getForeColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_REGION, DirectionType.toString(meta.getArea()), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_POSITION, meta.getPosition(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFT, meta.getLeft(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOP, meta.getTop(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHT, meta.getRight(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOM, meta.getBottom(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FLOATTYPE, meta.getFloatType(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PANDDING, meta.getPadding(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTPANDDING, meta.getLeftPadding(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTPADDING, meta.getRightPadding(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPPADDING, meta.getTopPadding(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMPADDING, meta.getBottomPadding(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_MARGIN, meta.getMargin(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTMARGIN, meta.getLeftMargin(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTMARGIN, meta.getRightMargin(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMMARGIN, meta.getBottomMargin(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HALIGN, meta.getHAlign(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALIGN, meta.getVAlign(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BORDERCOLOR, meta.getBorderColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BORDERSTYLE, meta.getBorderStyle(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BORDERRADIUS, meta.getBorderRadius(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABORDER, meta.getTabOrder(), -1);

		String tooltip = builder.getString(GroupKeyTable.STR_TIP, "", meta.getKey(), meta.getToolTip());
		JSONHelper.writeToJSON(json, JSONConstants.BASECONTROL_TIP, tooltip, "");

		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CSSCLASS, meta.getCssClass(), "");

		json.put(JSONConstants.COMMON_CANRECEIVEFOCUS, meta.receiveFocus());
		json.put(JSONConstants.COMMON_ISPANEL, meta.isPanel());

		MetaFormat formatMeta = meta.getFormat();
		JSONObject formatJSON = new JSONObject();
		if (formatMeta != null) {
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_FORECOLOR, formatMeta.getForeColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_BACKCOLOR, formatMeta.getBackColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR,
					formatMeta.getHighlightBackColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HALIGN, formatMeta.getHAlign(), -1);
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_VALIGN, formatMeta.getVAlign(), -1);
			JSONObject fontJSON = new JSONObject();
			MetaFont fontMeta = formatMeta.getFont();
			if (fontMeta != null) {
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_NAME, fontMeta.getName(), "");
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_SIZE, fontMeta.getSize(), -1);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_BOLD, fontMeta.isBold(), false);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_ITALIC, fontMeta.isItalic(), false);
			}
			formatJSON.put(JSONConstants.FORMAT_FONT, fontJSON);
		}
		json.put(JSONConstants.COMMON_FORMAT, formatJSON);

		if (meta.getWidth() != null) {
			if (meta.getWidth().getSizeType() == DefSize.Fix) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth().getSize(), 0);
			} else if (meta.getWidth().getSizeType() == DefSize.Ratio) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth().toString(), "0");
			} else {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth().toString(), "");
			}
		}
		if (meta.getHeight() != null) {
			if (meta.getHeight().getSizeType() == DefSize.Fix) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight().getSize(), 0);
			} else if (meta.getHeight().getSizeType() == DefSize.Ratio) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight().toString(), "0");
			} else if (meta.getHeight().getSizeType() == DefSize.Pref) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, DefSize.STR_Pref, "");
			} else {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight().toString(), "");
			}
		}

		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, meta.getTagName().toLowerCase(), "");
		json.put(JSONConstants.COMMON_METAOBJ, getMetaJSON(ve, builder, metaForm, meta));
	}

}
