package com.bokesoft.yes.mid.web.ui;

import java.util.HashMap;

import com.bokesoft.yes.mid.web.ui.load.BlockJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BodyJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.ContainerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.CustomJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.FormJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.anim.AnimCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.anim.AnimItemJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.commondef.ItemFilterCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.container.SubDetailJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.AttachmentJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.BPMGraphJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.CalendarJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ChartJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.CheckBoxJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.CheckListBoxJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ColorPickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ComboBoxJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.CompDictJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.CountDownViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.DatePickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.DateRangePickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.DictJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.DictViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.DropdownButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.DynamicDictJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.FileChooserJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.FlatCanvasJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.FontPickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.GIFImageJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.GanttJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.HyperLinkJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.IconJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ImageJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ImageListJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.LabelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.MapDrawJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.MonthPickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.NavigationListJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.NumberEditorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.NumberInfoEditorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.PasswordEditorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.PopButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ProgressBarJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ProgressIndicatorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.RadioButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.RefreshControlJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.RichEditorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ScoreBarJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.SearchBoxJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.SegmentedControlJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.SeparatorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ShrinkViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.SliderJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.SplitButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.StepEditorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.SwitchJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.TextAreaJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.TextButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.TextEditorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.TimePickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.TimeZoneDatePickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ToolBarJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.UTCDatePickerJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.UploadButtonJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.ValidateBoxJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.WebBrowserJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.grid.GridColumnJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.grid.GridJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listlayoutview.ListLayoutViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listlayoutview.RowLayoutCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listlayoutview.RowLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.ListViewColumnCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.ListViewColumnJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.ListViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.ListViewRowJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.extend.GalleryJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.extend.RotatorJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.extend.RotatorListJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.extend.TiledListJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.listview.extend.WaterFallJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.tabgroup.TabGroupJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.tabgroup.TabItemJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.wizardlist.WizardItemJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.wizardlist.WizardItemListJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.wizardlist.WizardListJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.navigationbar.NavigationBarItemJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.navigationbar.NavigationBarJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.BorderLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.ColumnLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.FlexFlowLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.FlowLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.FluidTableLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.GeneralPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.LinearLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.PagePanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.SlidingLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.SplitPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.TabPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.WizardPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.customlayoutpanel.CustomLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.flexboxpaneljsonbuilder.FlexBoxPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.ColumnDefCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.ColumnDefJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.ExtraLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.GridLayoutPanelJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.GroupJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.HandleJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.RowDefCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.panel.gridpanel.RowDefJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.popview.PopViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.tableview.TableRowJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.tableview.TableViewJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.BorderLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.ColumnLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.FlexFlowLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.FlowLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.FluidTableLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.GridLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.LinearLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.SplitLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.TabLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.TableLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.TableViewLayoutJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.ViewCollectionJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.viewcollection.WizardLayoutJSONBuilder;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaBorderLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaColumnLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexBox;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableViewLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaWizardLayout;

/**
 * @author 陈志盛
 * @author 李姝
 */
@SuppressWarnings("rawtypes")
public class UIJSONBuilderMap {
	private static HashMap<String, AbstractJSONBuilder> builders = null;
	
	static {
		if(builders == null) {
			builders = new HashMap<String, AbstractJSONBuilder>();
			
			// AbstractModel
			builders.put("Form", new FormJSONBuilder());
			builders.put("Body", new BodyJSONBuilder());
			builders.put(MetaViewCollection.TAG_NAME, new ViewCollectionJSONBuilder());
			
			builders.put(ControlType.STR_BLOCK, new BlockJSONBuilder());

			//ExtraLayout
			builders.put("ExtraLayout", new ExtraLayoutJSONBuilder());
			builders.put("Group", new GroupJSONBuilder());
			builders.put("Handle", new HandleJSONBuilder());

			builders.put("ColumnDefCollection", new ColumnDefCollectionJSONBuilder());
			builders.put("ColumnDef", new ColumnDefJSONBuilder());
			builders.put("ListViewColumnCollection", new ListViewColumnCollectionJSONBuilder());
			builders.put("ListViewColumn", new ListViewColumnJSONBuilder());
			builders.put("ListViewRow", new ListViewRowJSONBuilder());
			builders.put("RowDefCollection", new RowDefCollectionJSONBuilder());
			builders.put("RowDef", new RowDefJSONBuilder());
			builders.put("RowLayoutCollection", new RowLayoutCollectionJSONBuilder());
			builders.put("RowLayout", new RowLayoutJSONBuilder());
//			builders.put(TreeMenuEntryItem.TAGNAME, new TreeMenuEntryItemBuilder());
//			builders.put(TreeMenuEntry.TAGNAME, new TreeMenuEntryBuilder());
//			// TODO 为这些新添加Model？
//			builders.put(MetaTreeMenuItem.TAG_NAME, new TreeMenuEntryItemBuilder());
//			builders.put(MetaEntryItem.TAG_NAME, new TreeMenuEntryItemBuilder());
//			builders.put(MetaEntry.TAG_NAME, new TreeMenuEntryBuilder());
//			builders.put(MetaTreeMenuItemCollection.TAG_NAME, new TreeMenuEntryBuilder());
//			
//			// Component
			builders.put(ControlType.STR_CHART,new ChartJSONBuilder());
			builders.put(ControlType.STR_CONTAINER, new ContainerJSONBuilder());
//			builders.put(ControlType.STR_BUTTON_GROUP, new ButtonGroupJSONBuilder());
			builders.put(ControlType.STR_BUTTON, new ButtonJSONBuilder());
			builders.put(ControlType.STR_IMAGEBUTTON, new ButtonJSONBuilder());
			builders.put(ControlType.STR_POPBUTTON, new PopButtonJSONBuilder());
			builders.put(ControlType.STR_CHECKBOX, new CheckBoxJSONBuilder());
			builders.put(ControlType.STR_CHECKLISTBOX, new CheckListBoxJSONBuilder());
			builders.put(ControlType.STR_COLORPICKER, new ColorPickerJSONBuilder());
			builders.put(ControlType.STR_COMBOBOX, new ComboBoxJSONBuilder());
			builders.put(ControlType.STR_DATEPICKER, new DatePickerJSONBuilder());
			builders.put(ControlType.STR_DATERANGEPICKER, new DateRangePickerJSONBuilder());
			builders.put(ControlType.STR_MONTHPICKER, new MonthPickerJSONBuilder());
			builders.put(ControlType.STR_TIMEPICKER, new TimePickerJSONBuilder());
			builders.put(ControlType.STR_DICT, new DictJSONBuilder());
			//builders.put(ControlType.STR_CHAINDICT, new ChainDictJSONBuilder());
			builders.put(ControlType.STR_DYNAMICDICT, new DynamicDictJSONBuilder());
			builders.put(ControlType.STR_COMPDICT, new CompDictJSONBuilder());
			builders.put(ControlType.STR_DROPDOWNBUTTON, new DropdownButtonJSONBuilder());
			builders.put(ControlType.STR_FONTPICKER, new FontPickerJSONBuilder());
			builders.put(ControlType.STR_GRID, new GridJSONBuilder());
			builders.put(ControlType.STR_RICHEDITOR, new RichEditorJSONBuilder());
			builders.put(ControlType.STR_FILECHOOSER, new FileChooserJSONBuilder());
			builders.put(ControlType.STR_MAP, new MapDrawJSONBuilder());
			builders.put(ControlType.STR_UTCDATEPICKER, new UTCDatePickerJSONBuilder());
			builders.put(ControlType.STR_WEBBROWSER, new WebBrowserJSONBuilder());
			builders.put(ControlType.STR_GANTT, new GanttJSONBuilder());
			builders.put(ControlType.STR_PROGRESSINDICATOR, new ProgressIndicatorJSONBuilder());
			builders.put(ControlType.STR_WIZARDLIST, new WizardListJSONBuilder());
			builders.put("WizardItem", new WizardItemJSONBuilder());
			builders.put("WizardItemList", new WizardItemListJSONBuilder());
			builders.put(ControlType.STR_NAVIGATIONBAR, new NavigationBarJSONBuilder());
			builders.put(ControlType.STR_NAVIGATIONBARITEM, new NavigationBarItemJSONBuilder());
			builders.put(ControlType.STR_NAVIGATIONLIST, new NavigationListJSONBuilder());
			builders.put(ControlType.STR_UPLOADBUTTON, new UploadButtonJSONBuilder());
			builders.put(ControlType.STR_TIMEZONEDATEPICKER, new TimeZoneDatePickerJSONBuilder());
			
			//SubDetail
//			builders.put(ControlType.STR_SUBDETAIL, new SubDetailJSONBuilder());
//			
//			builders.put(ControlType.STR_HTML_ELEMENT_A, new Html_ABuilder());
//			builders.put(ControlType.STR_HTML_ELEMENT_LI, new Html_LIBuilder());
//			builders.put(ControlType.STR_HTML_ELEMENT_P, new Html_PBuilder());
//			builders.put(ControlType.STR_HTML_ELEMENT_UL, new Html_ULBuilder());
//			builders.put(ControlType.STR_HTML_SECTION, new HtmlSectionBuilder());
			
			builders.put(ControlType.STR_HYPERLINK, new HyperLinkJSONBuilder());
			builders.put(ControlType.STR_LABEL, new LabelJSONBuilder());
			builders.put(ControlType.STR_ICON, new IconJSONBuilder());
			builders.put(ControlType.STR_GIFIMAGE, new GIFImageJSONBuilder());
			builders.put(ControlType.STR_CALENDAR, new CalendarJSONBuilder());
			builders.put(ControlType.STR_LISTVIEW, new ListViewJSONBuilder());
			builders.put(ControlType.STR_LISTLAYOUTVIEW, new ListLayoutViewJSONBuilder());
			builders.put(ControlType.STR_GALLERY, new GalleryJSONBuilder());
			builders.put(ControlType.STR_WATERFALL, new WaterFallJSONBuilder());
			builders.put(ControlType.STR_TILEDLIST, new TiledListJSONBuilder());
			builders.put(ControlType.STR_ROTATOR, new RotatorJSONBuilder());
			builders.put(ControlType.STR_ROTATORLIST, new RotatorListJSONBuilder());
//			builders.put(ControlType.STR_MENUBAR, new MenuBarBuilder());
			builders.put(ControlType.STR_NUMBEREDITOR, new NumberEditorJSONBuilder());
			builders.put(ControlType.STR_STEPEDITOR, new StepEditorJSONBuilder());
			builders.put(ControlType.STR_PASSWORDEDITOR, new PasswordEditorJSONBuilder());
			builders.put(ControlType.STR_IMAGE, new ImageJSONBuilder());
			builders.put(ControlType.STR_IMAGELIST, new ImageListJSONBuilder());
			builders.put(ControlType.STR_PROGRESSBAR, new ProgressBarJSONBuilder());
			builders.put(ControlType.STR_RADIOBUTTON, new RadioButtonJSONBuilder());
//			builders.put(ControlType.STR_STATUSBAR, new StatusBarBuilder());
			builders.put(ControlType.STR_SPLITBUTTON, new SplitButtonJSONBuilder());
			builders.put(ControlType.STR_TEXTBUTTON, new TextButtonJSONBuilder());
			builders.put(ControlType.STR_TEXTEDITOR, new TextEditorJSONBuilder());
			builders.put(ControlType.STR_VALIDATEBOX, new ValidateBoxJSONBuilder());
			builders.put(ControlType.STR_TOOLBAR, new ToolBarJSONBuilder());
//			builders.put(ControlType.STR_TREEMENUBAR, new TreeMenuBarBuilder());
//			builders.put(ControlType.STR_TREEVIEW, new TreeViewBuilder());
			builders.put(ControlType.STR_DICTVIEW, new DictViewJSONBuilder());
			builders.put(ControlType.STR_CUSTOM, new CustomJSONBuilder());
			builders.put(ControlType.STR_BPM_GRAPH, new BPMGraphJSONBuilder());
			builders.put(ControlType.STR_FLATCANVAS, new FlatCanvasJSONBuilder());
			builders.put(ControlType.STR_TEXTAREA, new TextAreaJSONBuilder());
			builders.put(ControlType.STR_ATTACHMENT, new AttachmentJSONBuilder());
			builders.put(ControlType.STR_SEARCHBOX, new SearchBoxJSONBuilder());
			builders.put(ControlType.STR_SEPARATOR, new SeparatorJSONBuilder());
			
			builders.put(ControlType.STR_SCOREBAR, new ScoreBarJSONBuilder());
			builders.put(ControlType.STR_SWITCH, new SwitchJSONBuilder());
			builders.put(ControlType.STR_SEGMENTEDCONTROL, new SegmentedControlJSONBuilder());
			builders.put(ControlType.STR_NUMBERINFOEDITOR, new NumberInfoEditorJSONBuilder());
			builders.put(ControlType.STR_SLIDER, new SliderJSONBuilder());
			builders.put(ControlType.STR_COUNTDOWNVIEW, new CountDownViewJSONBuilder());
			builders.put(ControlType.STR_SHRINKVIEW, new ShrinkViewJSONBuilder());
			builders.put(ControlType.STR_TABGROUP, new TabGroupJSONBuilder());
			builders.put("TabItem", new TabItemJSONBuilder());
//			
//			// Panel
			builders.put(ControlType.STR_PANEL, new GeneralPanelJSONBuilder());
			builders.put(ControlType.STR_BORDERLAYOUTPANEL, new BorderLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_COLUMNLAYOUTPANEL, new ColumnLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_FLEXFLOWLAYOUTPANEL, new FlexFlowLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_FLOWLAYOUTPANEL, new FlowLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_GRIDLAYOUTPANEL, new GridLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_PAGEPANEL, new PagePanelJSONBuilder());
			builders.put(ControlType.STR_SPLITPANEL, new SplitPanelJSONBuilder());
			builders.put(ControlType.STR_TABPANEL, new TabPanelJSONBuilder());
			builders.put(ControlType.STR_FLUIDTABLELAYOUTPANEL, new FluidTableLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_WIZARDPANEL, new WizardPanelJSONBuilder());
			builders.put(ControlType.STR_SLIDINGLAYOUTPANEL, new SlidingLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_CUSTOMLAYOUTPANEL, new CustomLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_FLEXBOXPANEL, new FlexBoxPanelJSONBuilder());
			builders.put(MetaItemFilterCollection.TAG_NAME, new ItemFilterCollectionJSONBuilder());
			builders.put(MetaSubDetail.TAG_NAME, new SubDetailJSONBuilder());
			builders.put(MetaGridColumn.TAG_NAME, new GridColumnJSONBuilder());
			
			// Layout
			builders.put(MetaGridLayout.TAG_NAME, new GridLayoutJSONBuilder());
			builders.put(MetaBorderLayout.TAG_NAME, new BorderLayoutJSONBuilder());
			builders.put(MetaColumnLayout.TAG_NAME, new ColumnLayoutJSONBuilder());
			builders.put(MetaFlexFlowLayout.TAG_NAME, new FlexFlowLayoutJSONBuilder());
			builders.put(MetaFlowLayout.TAG_NAME, new FlowLayoutJSONBuilder());
			builders.put(MetaFluidTableLayout.TAG_NAME, new FluidTableLayoutJSONBuilder());
			builders.put(MetaLinearLayout.TAG_NAME, new LinearLayoutJSONBuilder());
			builders.put(MetaSplitLayout.TAG_NAME, new SplitLayoutJSONBuilder());
			builders.put(MetaTabLayout.TAG_NAME, new TabLayoutJSONBuilder());
			builders.put(MetaTableLayout.TAG_NAME, new TableLayoutJSONBuilder());
			builders.put(MetaTableViewLayout.TAG_NAME, new TableViewLayoutJSONBuilder());
			builders.put(MetaWizardLayout.TAG_NAME, new WizardLayoutJSONBuilder());
			builders.put(MetaFlexBox.TAG_NAME, new FlexBoxPanelJSONBuilder());
			
			//mobile
			builders.put(ControlType.STR_LINEARLAYOUTPANEL, new LinearLayoutPanelJSONBuilder());
			builders.put(ControlType.STR_TABLEVIEW, new TableViewJSONBuilder());
			builders.put(MetaTableRow.TAG_NAME, new TableRowJSONBuilder());
			builders.put(ControlType.STR_POPVIEW, new PopViewJSONBuilder());
			builders.put(ControlType.STR_REFRESHCONTROL, new RefreshControlJSONBuilder());
			
			//Anim
			builders.put(MetaAnimCollection.TAG_NAME, new AnimCollectionJSONBuilder());
			builders.put(MetaAnimItem.TAG_NAME, new AnimItemJSONBuilder()); 
		}
	}
	
	/**
	 * 根据组件类型获取组件的Builder。
	 * @param controlType 组件类型。
	 * @return 对应的组件Builder。
	 */
	@SuppressWarnings("unchecked")
	public static AbstractJSONBuilder<AbstractMetaObject> getBuilder(String tagName) {
		return builders.get(tagName); 
	}
}
