package com.bokesoft.yes.mid.web.service;

import java.util.HashMap;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yes.mid.web.cmd.GetAliasKeyCmd;
import com.bokesoft.yes.mid.web.cmd.GetBPMProcessCmd;
import com.bokesoft.yes.mid.web.cmd.GetClientAppStatusInfoCmd;
import com.bokesoft.yes.mid.web.cmd.GetCondSignItemsCmd;
import com.bokesoft.yes.mid.web.cmd.GetConditionItemsCmd;
import com.bokesoft.yes.mid.web.cmd.GetDataObjectCmd;
import com.bokesoft.yes.mid.web.cmd.GetDataObjectKeyCmd;
import com.bokesoft.yes.mid.web.cmd.GetDataObjectVersionCmd;
import com.bokesoft.yes.mid.web.cmd.GetDisplayColumnsCmd;
import com.bokesoft.yes.mid.web.cmd.GetDynamicCellKeyCmd;
import com.bokesoft.yes.mid.web.cmd.GetEnhanceCmd;
import com.bokesoft.yes.mid.web.cmd.GetEntryCmd;
import com.bokesoft.yes.mid.web.cmd.GetEntryItemCmd;
import com.bokesoft.yes.mid.web.cmd.GetFormByEntryCmd;
import com.bokesoft.yes.mid.web.cmd.GetFormByTypeCmd;
import com.bokesoft.yes.mid.web.cmd.GetFormCmd;
import com.bokesoft.yes.mid.web.cmd.GetFormVersionCmd;
import com.bokesoft.yes.mid.web.cmd.GetMacroCmd;
import com.bokesoft.yes.mid.web.cmd.GetParaGroupCmd;
import com.bokesoft.yes.mid.web.cmd.GetQueryColumnsCmd;
import com.bokesoft.yes.mid.web.cmd.GetRelationFormCmd;
import com.bokesoft.yes.mid.web.cmd.GetRelationFormKeyCmd;
import com.bokesoft.yes.mid.web.cmd.GetReportCmd;
import com.bokesoft.yes.mid.web.cmd.GetSettingCmd;
import com.bokesoft.yes.mid.web.cmd.GetStartItemCmd;
import com.bokesoft.yes.mid.web.cmd.GetStatusCollectionCmd;
import com.bokesoft.yes.mid.web.cmd.init.GetCommonDefCmd;
import com.bokesoft.yes.mid.web.cmd.init.GetFormStringsCmd;
import com.bokesoft.yes.mid.web.cmd.init.GetProjectStringsCmd;
import com.bokesoft.yes.mid.web.cmd.init.GetSolutionCmd;
import com.bokesoft.yes.mid.web.cmd.init.GetSolutionStringsCmd;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class WebMetaService extends GeneralService<DefaultContext> {
	@Override
	public String getServiceName() {
		return "WebMetaService";
	}
	
	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new WebMetaService();
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		return (IServiceCmd<DefaultContext>)WebMetaService.prototype.get(cmd);
	}

	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		WebMetaService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(WebMetaService.prototype, new WebMetaService());
	}

	@Override
	protected Object[][] getCmdImplTable() {

		return new Object[][]{
				{ "GetRelationForm", new GetRelationFormCmd() },
				{ "GetRelationFormKey", new GetRelationFormKeyCmd() },
				{ "GetMacro", new GetMacroCmd() },
				{ "GetReport", new GetReportCmd() },
				{ "GetFormByType", new GetFormByTypeCmd() },
				{ "GetStatusCollection", new GetStatusCollectionCmd() },
				{ "GetParaGroup", new GetParaGroupCmd() },
				{ "GetForm", new GetFormCmd() },
				{ "GetFormByEntry", new GetFormByEntryCmd() },
				{ "GetEntry", new GetEntryCmd() },
				{ "GetEntryItem", new GetEntryItemCmd() },
				{ "GetDataObjectKey", new GetDataObjectKeyCmd() },
				{ "GetDataObject", new GetDataObjectCmd() },
				{ "GetQueryColumns", new GetQueryColumnsCmd() },
				{ "GetDisplayColumns", new GetDisplayColumnsCmd() },
				{ "GetClientAppStatusInfo", new GetClientAppStatusInfoCmd() },
				{ "GetAliasKey", new GetAliasKeyCmd() },
				{ "GetConditionItems", new GetConditionItemsCmd() },
				{ "GetCondSignItems", new GetCondSignItemsCmd() },
				{ "GetDynamicCellKey", new GetDynamicCellKeyCmd() },
				{ "GetBPMProcess", new GetBPMProcessCmd() },
				{ "GetStartItem", new GetStartItemCmd() },
				{ "GetDataObjectVersion", new GetDataObjectVersionCmd() },
				{ "GetFormVersion", new GetFormVersionCmd() },
				{ "GetEnhance", new GetEnhanceCmd() },
				{ "GetSetting", new GetSettingCmd() },
				{ "GetSolution", new GetSolutionCmd() },
				{ "GetSolutionStrings", new GetSolutionStringsCmd() },
				{ "GetFormStrings", new GetFormStringsCmd() },
				{ "GetProjectStrings", new GetProjectStringsCmd() },
				{ "GetCommonDef", new GetCommonDefCmd() },
		};
	}

	@Override
	public void checkSecurity(DefaultContext context, String cmd, StringHashMap<Object> arguments) throws Throwable {
		if(context.getEnv().getMode() == LoginMode.MOBILE) {
			super.checkSecurity(context, cmd, arguments);
		}
	}
	
	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return null;
	}

}