package com.bokesoft.yes.mid.web.service;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.MetaProcessJsonSerializer;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class InplaceToolBarService extends GeneralService<DefaultContext> {

	static final String BPM_PROCESS_KEY = "BPM_PROCESS_KEY";
	static final String BPM_ACTION_NODE_KEY = "BPM_ACTION_NODE_KEY";
	
	@Override
	public String getServiceName() {
		return "InplaceToolBar";
	}

	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new InplaceToolBarService();
	}

	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Object[][] getCmdImplTable() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return new BatchOperationImpl();
	}

	private class BatchOperationImpl extends DefaultServiceCmd {

		private String formKey = null;
		
		@Override
		public void dealArguments(DefaultContext context,
				StringHashMap<Object> arguments) throws Throwable {
			formKey = TypeConvertor.toString(arguments.get("formKey"));
		}

		@Override
		public Object doCmd(DefaultContext context) throws Throwable {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			MidVEHost veHost = new MidVEHost(context);
			IMetaFactory factory = veHost.getVE().getMetaFactory();
			MetaProcessMap pm = factory.getMetaBPM().getMetaProcessMapCollection().getDataobjectMapInfo(metaForm.getDataSource().getDataObject().getRelateObjectKey());
			if (pm != null) {
				String processKey = pm.getProcessKey();
				MetaProcess process = factory.getProcessDefinationByDeployKey(processKey);
				if (process != null) {
					MetaProcessJsonSerializer serializer = new MetaProcessJsonSerializer(process, veHost);
					return serializer.serialize();
				}
			}
			return null;
		}

		@Override
		public IServiceCmd<DefaultContext> newInstance() {
			return new BatchOperationImpl();
		}

		@Override
		public String getCmd() {
			return "batchOperation";
		}
		
	}
}
