package com.bokesoft.yes.mid.web.cmd;

import java.io.ByteArrayOutputStream;
import java.util.List;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.util.PrintPDF;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.common.util.UIUtil;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class PrintPDFCmd extends DefaultServiceCmd {
	private Document doc = null;
	private String formKey = null;
	private List<String> reportKeys = null;
	private boolean fillEmptyPrint = false;
	private AbstractRuntimeUIConfig runtimeUIConfig;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = TypeConvertor.toString(arguments.get("parameters"));
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
		String str = TypeConvertor.toString(arguments.get("doc"));
	
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		
		doc = new Document(null, -1);
		JSONObject json = new JSONObject(str);
		doc.fromJSON(json);
		
		String strReportKeys = TypeConvertor.toString(arguments.get("reportKey"));
		reportKeys = PrintPDF.transReportKeyList(strReportKeys);
		
		fillEmptyPrint = TypeConvertor.toBoolean(arguments.get("fillEmptyPrint"));
		
		String uiconfig = TypeConvertor.toString(arguments.get("uiconfig"));
		if (!StringUtil.isBlankOrNull(uiconfig) && !"{}".equals(uiconfig)) {
			JSONObject jsonUI = new JSONObject(uiconfig);
			runtimeUIConfig = UIUtil.createRuntimeConfig(jsonUI);
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		List<MetaReport> metaReports = PrintPDF.getMetaReports(formKey, reportKeys, context);
		ByteArrayOutputStream baos = null;
		try {
			PrintPDF print = new PrintPDF(formKey, metaReports, fillEmptyPrint);
			baos = print.printPDF(context, doc, runtimeUIConfig);
			return new String(Base64.encode(baos.toByteArray()));
		} finally {
			if( baos != null ) {
				baos.close();
			}
		}
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new PrintPDFCmd();
	}

	@Override
	public String getCmd() {
		return "Print";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}