package com.bokesoft.yes.mid.web.cmd;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaParaItem;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;

public class GetParaGroupCmd extends DefaultServiceCmd {

	private String groupKey = "";
	private String formKey = "";
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		groupKey = (String) arguments.get("groupKey");
		formKey = (String) arguments.get("formKey");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		VE ve = context.getVE();
		IMetaFactory metaFactory = ve.getMetaFactory();

		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		
		MetaParaGroup metaParaGroup = MetaUtil.getParaGroup(metaFactory, metaForm, groupKey);
		
		JSONArray itemsArry = null;
		if( metaParaGroup != null ) {
			itemsArry = new JSONArray();
			Iterator<MetaParaItem> it = metaParaGroup.iterator();
			MetaParaItem metaParaItem = null;
			while (it.hasNext()) {
				metaParaItem = it.next();
				JSONObject paraJSON = new JSONObject();
				JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_KEY, metaParaItem.getKey(), "");
				JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_CAPTION, metaParaItem.getCaption(), "");
				JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_VALUE, metaParaItem.getValue(), "");
				itemsArry.put(paraJSON);
			}
		}
		
		return itemsArry;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetParaGroupCmd();
	}

	@Override
	public String getCmd() {
		return "GetParaGroup";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}

