package com.bokesoft.yes.mid.web.cmd;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetMacroCmd extends DefaultServiceCmd {

	private String formKey = null;
	private String macroName = null;
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		macroName = TypeConvertor.toString(arguments.get("macroName"));
		
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(this.formKey);
		MetaMacroCollection macroCollection = null;
		MetaMacro metaMacro = null;
		
		MetaProject metaProject = (MetaProject) metaForm.getProject();
		String projectKey = null;
		MetaCommonDef metaCommonDef = metaFactory.getCommondDef(metaProject.getKey());
		if (metaCommonDef != null) {
			macroCollection = metaCommonDef.getMacroCollection();
			if (macroCollection != null) {
				metaMacro = macroCollection.get(macroName);
				projectKey = metaProject.getKey();
			}
		}
		if (metaMacro == null) {
			metaCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey());
			if (metaCommonDef != null) {
				macroCollection = metaCommonDef.getMacroCollection();
				if (macroCollection != null) {
					metaMacro = macroCollection.get(macroName);
					projectKey = null;
				}
			}
		}
		if (metaMacro == null) {
			metaCommonDef = metaFactory.getCommondDef("");
			if (metaCommonDef != null) {
				macroCollection = metaCommonDef.getMacroCollection();
				if (macroCollection != null) {
					metaMacro = macroCollection.get(macroName);
					projectKey = null;
				}
			}
		}
		if(metaMacro != null) {
			JSONObject macroObj = new JSONObject();
			macroObj.put("key", metaMacro.getKey());
			macroObj.put("args", metaMacro.getArgsList());
			macroObj.put("content", metaMacro.getContent());
			macroObj.put("project", projectKey);
			return macroObj;
		} else {
			return null;
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetMacroCmd();
	}

	@Override
	public String getCmd() {
		return "GetMacro";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
