package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.session.DefaultSessionCheck;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class GetFormVersionCmd extends DefaultServiceCmd {
	
	private String formKey = null;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
		int version = metaForm.getVersion();
		return version;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetFormVersionCmd();
	}

	@Override
	public String getCmd() {
		return "GetFormVersion";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
