package com.bokesoft.yes.mid.web.cmd;

import java.util.Date;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.mid.web.util.IExtensionProvider;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.BaseTypeUtil;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.rights.IRightsProvider;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.web.WebException;
import com.bokesoft.yes.mid.web.ui.WebJSONUIBuilder;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.JavaDataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;
import com.bokesoft.yigo.mid.service.security.SecurityCheckHandler;
import com.bokesoft.yigo.struct.rights.EntryRights;
import com.bokesoft.yigo.tools.ve.VE;

public class GetFormByEntryCmd extends DefaultServiceCmd {

	private String path = null;
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		path = TypeConvertor.toString(arguments.get("path"));
	}
	
	@Override
	public void checkSecurity(IServiceProvider<DefaultContext> service, DefaultContext context, String cmd,
			StringHashMap<Object> arguments) throws Throwable {
		SecurityCheckHandler.getInstance().check(context, arguments);
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		VE ve = context.getVE();
		boolean hasRights = AuthorityCheckUtil.hasEntryRights(context, "");
		if(!hasRights){
			throw new WebException(WebException.NO_ENTRYRIGHTS, 
					WebException.formatMessage(null, WebException.NO_ENTRYRIGHTS, path));
		}
		
		
		IMetaFactory metaFactory = ve.getMetaFactory();
		MetaEntryItem metaEntryItem = metaFactory.getMetaEntryItem(path);
		
		if(metaEntryItem == null){
			return null;
		}
		
		String formKey = metaEntryItem.getFormKey();
		
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MidVEHost veHost = new MidVEHost(context);
		veHost.setVE(context.getVE());
				
		WebJSONUIBuilder builder = new WebJSONUIBuilder();
		builder.setVEHost(veHost);
		builder.setMetaForm(metaForm);
		
		JSONObject formJson = builder.build();
		
		JSONObject parasJson = new JSONObject();
		JSONArray items = new JSONArray();

		// 菜单树的参数
		String parameters = metaEntryItem.getParameters();
		if ( parameters != null && !parameters.isEmpty() ) {
			String[] v = parameters.split(";");
			int length = v.length;
			for ( int i = 0; i<length; ++i ) {
				String s = v[i];
				int index = s.indexOf('=');
				JSONObject item = getParameter(s.substring(0, index), s.substring(index + 1));
				items.put(item);
			}
		}
		
		// 默认参数
		items.put(getParameter("EntryKey", metaEntryItem.getKey()));
		items.put(getParameter("EntryCaption", MetaUtil.getString(ve.getMetaFactory(), 
				ve.getEnv().getLocale(), metaEntryItem.getProject(), GroupKeyTable.STR_ENTRY, path.replace('/','_'), metaEntryItem.getCaption())));
		
		// 表单的参数通过paraTree传输
		parasJson.put(JSONConstants.COMMON_ITEMS, items);
		formJson.put(JSONConstants.FORM_PARAMETERS, parasJson);

		//前台扩展表单合并处理
		IExtensionProvider provider = ExtensionUtil.newProvider();
		if(provider != null){
			MetaForm extForm = provider.getExtMetaForm(context, metaForm);
			if (extForm != null) {
				WebJSONUIBuilder extFormBuilder = new WebJSONUIBuilder();
				extFormBuilder.setVEHost(veHost);
				extFormBuilder.setMetaForm(extForm);
				JSONObject extFormJSON = extFormBuilder.build();
				JSONObject mergeInfo = new JSONObject();
				JSONHelper.writeToJSON(mergeInfo, JSONConstants.FORM_FORMINFO, extFormJSON);
				JSONHelper.writeToJSON(formJson, JSONConstants.FORM_DELAYMERGEINFO, mergeInfo);
			}
		}

		return formJson;
	}

	private JSONObject getParameter(String key, Object value) {
		JSONObject item = new JSONObject();
		item.put(JSONConstants.COMMON_KEY, key);
		int type = BaseTypeUtil.getType(value);	
		switch (type) {
		case JavaDataType.USER_DATETIME:
			long date = ((Date)value).getTime();
			item.put(JSONConstants.COMMON_VALUE, date);
			break;
		default:
			item.put(JSONConstants.COMMON_VALUE, value);
			break;
		}
		item.put(JSONConstants.COMMON_TYPE, type);
		return item;
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetFormByEntryCmd();
	}

	@Override
	public String getCmd() {
		return "GetFormByEntry";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
