package com.bokesoft.yes.mid.web.cmd;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbarCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDefCollection;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundPool;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorDef;
import com.bokesoft.yigo.meta.mobiledef.encrypt.MetaEncryptSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.solution.MetaStartItemCollection;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;

public class GetEnvDefParasCmd extends DefaultServiceCmd {

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		JSONObject envDefParas = new JSONObject();

		// 转换MetaSolution中的全局变量
		MetaSolution metaSolution = context.getVE().getMetaFactory().getSolution();
		envDefParas.put("MetaSolution", this.transformSolutionParas(context.getVE(),metaSolution));

		// 转换根目录下的MetaCommonDef中的全局变量
		MetaCommonDef metaCommonDef = context.getVE().getMetaFactory().getCommondDef(null);
		envDefParas.put("MetaCommonDef", this.transformCommonDefParas(metaCommonDef));

		// 转换根目录下的MetaMobileDef中的全局变量
		MetaMobileDef metaMobileDef = context.getVE().getMetaFactory().getMobileDef(null);
		envDefParas.put("MetaMobileDef", this.transformMobileDefParas(context.getVE(),metaMobileDef));

		// 转换根目录下的MetaSetting中的全局变量
		MetaSetting metaSetting = context.getVE().getMetaFactory().getSetting();
		envDefParas.put("MetaSetting", this.transformSettingParas(metaSetting));

		return envDefParas;
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetEnvDefParasCmd();
	}

	@Override
	public String getCmd() {
		return "GetEnvDefParas";
	}

	private JSONObject transformSolutionParas(VE ve,MetaSolution metaSolution) throws Throwable {
		JSONObject jsonObject = new JSONObject();
		jsonObject.put(JSONConstants.SOLUTION_ENABLEMULTILANG, metaSolution.isEnableMultiLang());
		jsonObject.put(JSONConstants.SOLUTION_DEFAULTLANG, metaSolution.getDefaultLang());
		
		SolutionSerializeContext context = new SolutionSerializeContext(ve);
		
		MetaInplaceToolbarCollection toolBarCollection = metaSolution.getInplaceToolBarCollection();
		if (toolBarCollection != null) {
			jsonObject.put(JSONConstants.SOLUTION_INPLACETOOLBARCOLLECTION, UIJSONHandlerUtil.buildKeyCollection(context, toolBarCollection));
		}

		MetaStartItemCollection itemCollection = metaSolution.getStartItemCollection();
		if (itemCollection != null) {
			jsonObject.put(JSONConstants.SOLUTION_STARTITEMCOLLECTION, UIJSONHandlerUtil.buildKeyCollection(context, itemCollection));
		}

		MetaLangConfig langConfig = metaSolution.getLangConfig();
		if (langConfig != null) {
			jsonObject.put(JSONConstants.SOLUTION_LANGCONFIG, UIJSONHandlerUtil.buildKeyCollection(context, langConfig));
		}

		IMetaFactory metaFactory = ve.getMetaFactory();
		MetaStringTable strings = metaFactory.getStrings();
		if (strings != null) {
			jsonObject.put(JSONConstants.SOLUTION_STRINGTABLE, strings.toJSON());
		}
		return jsonObject;
	}

	private JSONObject transformCommonDefParas(MetaCommonDef metaCommonDef) {
		JSONObject jsonObject = new JSONObject();

		return jsonObject;
	}

	private JSONObject transformMobileDefParas(VE ve,MetaMobileDef metaMobileDef) throws Throwable {
		JSONObject jsonObject = new JSONObject();
		
		SolutionSerializeContext context = new SolutionSerializeContext(ve);

		MetaEventDefCollection eventDefCollection = metaMobileDef.getEventDefCollection();
		if (eventDefCollection != null) {
			jsonObject.put(JSONConstants.MOBILEDEF_EVENTDEFCOLLECTION, UIJSONHandlerUtil.buildKeyCollection(context, eventDefCollection));
		}

		MetaVibratorDef vibratorDef = metaMobileDef.getVibratorDef();
		if (vibratorDef != null) {
			jsonObject.put(JSONConstants.MOBILEDEF_VIBRATORDEF, UIJSONHandlerUtil.buildKeyCollection(context, vibratorDef));
		}
		
		MetaSoundPool metaSoundPool = metaMobileDef.getSoundPool();
		if(metaSoundPool != null){
			jsonObject.put(JSONConstants.MOBILEDEF_SOUNDPOOL, UIJSONHandlerUtil.buildKeyCollection(context, metaSoundPool));
		}
		
		MetaEncryptSetting encryptSetting = metaMobileDef.getEncryptSetting();
		if( encryptSetting != null ) {
			jsonObject.put(JSONConstants.MOBILEDEF_ENCRYPTSETTING, UIJSONHandlerUtil.build(encryptSetting, context));
		}
		
		jsonObject.put(JSONConstants.MOBILEDEF_VERSIONPATH, metaMobileDef.getVersionPath());
		jsonObject.put(JSONConstants.MOBILEDEF_SYSLANGUAGE, metaMobileDef.isSysLanguage());
		jsonObject.put(JSONConstants.MOBILEDEF_PASSERRORCOUNT, metaMobileDef.getPassErrorCount());
		jsonObject.put(JSONConstants.MOBILEDEF_PASSENABLETIME, metaMobileDef.getPassEnableTime());
		jsonObject.put(JSONConstants.MOBILEDEF_SERVERVERSION, metaMobileDef.getServerVersion());
		return jsonObject;
	}

	private JSONObject transformSettingParas(MetaSetting metaSetting) {
		JSONObject jsonObject = new JSONObject();

		if(metaSetting.getBPMSetting() != null){
		}
		return jsonObject;
	}

	
}
