package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetEntryItemCmd extends DefaultServiceCmd {
	private String entryPath = null;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		entryPath = (String) arguments.get("entryPath");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaEntryItem entryItem = metaFactory.getMetaEntryItem(entryPath);
		if( entryItem != null ) {
			return UIJSONHandlerUtil.build(entryItem, new SolutionSerializeContext(context.getVE()));
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetEntryItemCmd();
	}

	@Override
	public String getCmd() {
		return "GetEntryItem";
	}

}
