package com.bokesoft.yes.mid.web.cmd;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;

public class GetConditionItemsCmd extends DefaultServiceCmd{
	private String formKey = "";
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		VE ve = context.getVE();
		IMetaFactory metaFactory = ve.getMetaFactory();
		
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		JSONArray itemsArry = new JSONArray();

		if(metaForm != null){
			MetaComponent metaComponent = null;
			Iterator<MetaComponent> itComponent = metaForm.getAllComponents().iterator();
			while (itComponent.hasNext()) {
				metaComponent = itComponent.next();
				
				if (metaComponent.getControlType() == ControlType.GRID) {
					// 处理查询的表格字段
					MetaGrid grid= (MetaGrid) metaComponent;
					MetaGridCell cell = null;
					Iterator<MetaGridCell> it= grid.getDetailMetaRow().iterator();
					while (it.hasNext()) {
						cell = it.next();
						if (cell.isAsQuery()) {							
							JSONObject itemJSON = new JSONObject();
							JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, cell.getKey(), "");
							JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, cell.getCaption(), "");
							itemJSON.put(JSONConstants.COMMON_VALUE, cell.getKey());
							itemsArry.put(itemJSON);
						}
					}
				} else {
					// 处理查询的头控件
					if ( metaComponent.isAsQuery()){
						JSONObject itemJSON = new JSONObject();
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaComponent.getKey(), "");
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, metaComponent.getCaption(), "");
						itemJSON.put(JSONConstants.COMMON_VALUE, metaComponent.getKey());
						itemsArry.put(itemJSON);
					}
				}
			}
		}
		return itemsArry;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetConditionItemsCmd();
	}

	@Override
	public String getCmd() {
		return "GetConditionItems";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
