package com.bokesoft.yes.mid.web.cmd;

import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.util.PrintPDF;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class BatchPrintPDFCmd extends DefaultServiceCmd {
	private String formKey = null;
	private String reportKey = null;
	private List<String> reportKeys = null;
	private LinkedList<Long> OIDs = new LinkedList<Long>();
	private boolean fillEmptyPrint = false;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = TypeConvertor.toString(arguments.get("parameters"));
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
	
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		//reportKey = TypeConvertor.toString(arguments.get("reportKey"));
		String strReportKeys = TypeConvertor.toString(arguments.get("reportKey"));
		reportKeys = PrintPDF.transReportKeyList(strReportKeys);
		fillEmptyPrint = TypeConvertor.toBoolean(arguments.get("fillEmptyPrint"));

		String OIDList = TypeConvertor.toString(arguments.get("OIDs"));
		JSONArray array = new JSONArray(OIDList);
		for (int i = 0,size = array.length(); i < size; i++) {
			this.OIDs.add(array.getLong(i));
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		if (OIDs.size() == 0) {
			throw new Throwable("Function BatchPrintPDF need provide OIDS");
		}
		List<MetaReport> metaReports = PrintPDF.getMetaReports(formKey, reportKeys, context);
		ByteArrayOutputStream baos = null;
		try {
			PrintPDF print = new PrintPDF(formKey, metaReports, fillEmptyPrint);
			baos = print.batchPrintPdf(context, OIDs);
			return new String(Base64.encode(baos.toByteArray()));
		} finally {
			if( baos != null ) {
				baos.close();
			}
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new BatchPrintPDFCmd();
	}

	@Override
	public String getCmd() {
		return "BatchPrintPDF";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}

}