/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.session;

import com.bokesoft.yigo.mid.auth.Login;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.LoginInfo;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.session.SessionUtils$SSOLogin;
import com.bokesoft.yigo.session.SessionUtils$YigoRunnable;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SessionUtils {
    public static final int LOGIN_MODE_PC = 1;
    public static final int LOGIN_MODE_MOBILE = 2;
    private static final String ENV_TIME_PATTERN = "yyyy/MM/dd HH:mm:ss";

    public static String login(String string, String string2, String string3, int n2) {
        return SessionUtils.processWithContext(null, defaultContext -> {
            Env env = defaultContext.getEnv();
            string = string + "-" + UUID.randomUUID().toString();
            env.setClientID(string);
            string3 = string3 == null ? "" : string3;
            string3 = new LoginInfo(string2, string3, -1L, n2, "", null);
            string3 = new Login((LoginInfo)string3);
            try {
                ((Login)((Object)string3)).doLogin(defaultContext);
                return string;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    public static String loginBackend(String string) {
        return SessionUtils.loginBackend(string, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loginBackend(String string, int n2) {
        DefaultContext defaultContext = null;
        try {
            defaultContext = ContextBuilder.create();
            string = SessionUtils.loginBackend(defaultContext, string, n2, null);
            defaultContext.commit();
        }
        catch (Throwable throwable) {
            try {
                try {
                    defaultContext.rollback();
                    throw new RuntimeException(throwable);
                }
                catch (Throwable throwable2) {}
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable3) {
                try {
                    defaultContext.close();
                    throw throwable3;
                }
                catch (Throwable throwable4) {}
                throw throwable3;
            }
        }
        try {
            defaultContext.close();
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String loginBackend(DefaultContext defaultContext, String string, int n2, Map<String, Object> map) {
        return SessionUtils.loginBackend(defaultContext, string, null, n2, map);
    }

    public static String loginBackend(DefaultContext defaultContext, String object, String string, int n2, Map<String, Object> map) {
        Env env = defaultContext.getEnv();
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = UUID.randomUUID().toString();
        }
        env.setClientID(string);
        object = new LoginInfo((String)object, "", -1L, n2, "", map);
        object = new SessionUtils$SSOLogin((LoginInfo)object);
        try {
            defaultContext = ((Login)object).doLogin(defaultContext);
            long l2 = defaultContext.getLong("UserID");
            SessionUtils.wrapEnvSetUserID(env, l2);
            object = defaultContext.getString("Name");
            env.setUserName((String)object);
            long l3 = defaultContext.getLong("Time");
            env.setTime(DateFormatUtils.format((Date)new Date(l3), (String)ENV_TIME_PATTERN));
            env.setMode(n2);
            return string;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void wrapEnvSetUserID(Env env, long l2) {
        env.getUserID();
        env.setUserID(Long.valueOf(l2));
    }

    public static boolean attachSession(DefaultContext defaultContext, String string) {
        return SessionUtils.attachSession(defaultContext, string, 1);
    }

    public static boolean attachSession(DefaultContext defaultContext, String string, int n2) {
        defaultContext = defaultContext.getEnv();
        if ((string = SessionUtils.getLoginSession(string)) != null) {
            defaultContext.setClientID(string.getClientID());
            defaultContext.setClientIP(string.getIP());
            defaultContext.setClusterid(string.getClusterID());
            defaultContext.setGuestUserID(string.getGuestUserID());
            defaultContext.setMode(string.getMode());
            defaultContext.setSessionParas(string.getSessionParas());
            defaultContext.setTicketID(string.getTicketID());
            SessionUtils.wrapEnvSetUserID((Env)defaultContext, string.getOperatorID());
            defaultContext.setRoleIDList((List)string.getRoleIDList());
            defaultContext.setMode(n2);
            defaultContext.setSessionParas(string.getSessionParas());
            return true;
        }
        return false;
    }

    public static boolean attachBackgroundSession(DefaultContext defaultContext, String string) {
        return SessionUtils.attachBackgroundSession(defaultContext, string, 1);
    }

    public static boolean attachBackgroundSession(DefaultContext object, String string, int n2) {
        Env env = object.getEnv();
        object = object.getVE().getDictCache();
        try {
            object = object.locate("Operator", "Code", (Object)string, null, null, 7, null, null, 0);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        if (object != null) {
            object = object.getID();
            env.setClientID("BG-" + UUID.randomUUID());
            SessionUtils.wrapEnvSetUserID(env, (Long)object);
            env.setUserCode(string);
            env.setMode(1);
            return true;
        }
        return false;
    }

    public static ISessionInfo getLoginSession(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        ISessionInfo iSessionInfo = SessionInfoProviderHolder.getProvider((int)1).getSessionInfoMap().get(string);
        if (iSessionInfo == null) {
            iSessionInfo = SessionInfoProviderHolder.getProvider((int)2).getSessionInfoMap().get(string);
        }
        return iSessionInfo;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T processWithContext(String string, SessionUtils$YigoRunnable<T> sessionUtils$YigoRunnable) {
        Object t2;
        DefaultContext defaultContext = null;
        try {
            void var1_4;
            defaultContext = ContextBuilder.create();
            SessionUtils.attachSession(defaultContext, string);
            t2 = var1_4.run(defaultContext);
            defaultContext.commit();
            if (defaultContext == null) return t2;
        }
        catch (Throwable throwable) {
            try {
                if (defaultContext == null) throw new RuntimeException(throwable);
                try {
                    defaultContext.rollback();
                    throw new RuntimeException(throwable);
                }
                catch (Throwable throwable2) {}
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable3) {
                if (defaultContext == null) throw throwable3;
                try {
                    defaultContext.close();
                    throw throwable3;
                }
                catch (Throwable throwable4) {}
                throw throwable3;
            }
        }
        try {
            defaultContext.close();
            return t2;
        }
        catch (Throwable throwable) {
            return t2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T processWithBackgroundContext(String string, SessionUtils$YigoRunnable<T> sessionUtils$YigoRunnable) {
        Object t2;
        DefaultContext defaultContext = null;
        try {
            void var1_4;
            defaultContext = ContextBuilder.create();
            SessionUtils.attachBackgroundSession(defaultContext, string);
            t2 = var1_4.run(defaultContext);
            defaultContext.commit();
            if (defaultContext == null) return t2;
        }
        catch (Throwable throwable) {
            try {
                if (defaultContext == null) throw new RuntimeException(throwable);
                try {
                    defaultContext.rollback();
                    throw new RuntimeException(throwable);
                }
                catch (Throwable throwable2) {}
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable3) {
                if (defaultContext == null) throw throwable3;
                try {
                    defaultContext.close();
                    throw throwable3;
                }
                catch (Throwable throwable4) {}
                throw throwable3;
            }
        }
        try {
            defaultContext.close();
            return t2;
        }
        catch (Throwable throwable) {
            return t2;
        }
    }
}

