/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.session;

import com.bokesoft.yes.mid.redis.RedisCache;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.nosql.Connection;
import com.bokesoft.yigo.mid.nosql.ConnectionFactory;
import com.bokesoft.yigo.mid.session.ICacheFactory;
import java.io.FileInputStream;
import java.util.Properties;

public class RedisSessionCacheFactory
implements ICacheFactory {
    private Properties properties;

    public RedisSessionCacheFactory(IMetaFactory iMetaFactory) {
        try {
            this.init();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void init() throws Throwable {
        FileInputStream fileInputStream = PropertyUtil.readProperties((String)"redis-session.properties");
        String string = "redis-session-cluster.properties";
        if (fileInputStream == null) {
            fileInputStream = PropertyUtil.readProperties((String)"redis.properties");
            string = "redis-cluster.properties";
        }
        if (fileInputStream == null) {
            throw new MidCoreException(36, MidCoreException.formatMessage(null, (int)36, (Object[])new Object[0]));
        }
        try {
            this.properties = new Properties();
            this.properties.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        boolean bl = false;
        if (this.properties.containsKey("Cluster") && (bl = Boolean.parseBoolean(this.properties.getProperty("Cluster")))) {
            fileInputStream = PropertyUtil.readProperties((String)string);
            try {
                this.properties = new Properties();
                this.properties.load(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        this.properties.setProperty("cluster", String.valueOf(bl));
    }

    public <V> ICache<V> createCache(String string) {
        Connection connection = ConnectionFactory.getInstance().getConnection(this.properties);
        return new RedisCache(string, connection);
    }
}

