/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.paper;

import com.bokesoft.yes.report.output.OutputPage;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.print.paper.IPrintPaper;

public class PrintPaper
implements IPrintPaper {
    protected OutputPageSet pageSet = new OutputPageSet();

    @Override
    public OutputPageSet getPageSet() {
        return this.pageSet;
    }

    @Override
    public int getWidth() {
        OutputPage outputPage = this.getFirstPage();
        if (outputPage != null) {
            if (outputPage.isVirtualPage()) {
                return outputPage.getPaperWidth();
            }
            return outputPage.getPageWidth();
        }
        return 0;
    }

    @Override
    public int getHeight() {
        OutputPage outputPage = this.getFirstPage();
        if (outputPage != null) {
            if (outputPage.isVirtualPage()) {
                return outputPage.getPaperHeight();
            }
            return outputPage.getPageHeight();
        }
        return 0;
    }

    @Override
    public int getOrientation() {
        OutputPage outputPage = this.getFirstPage();
        if (outputPage != null) {
            return outputPage.getPaperOrientation();
        }
        return 0;
    }

    @Override
    public void add(OutputPage outputPage) {
        this.pageSet.add(outputPage);
    }

    @Override
    public boolean isEmpty() {
        return this.pageSet.size() == 0;
    }

    @Override
    public boolean hasEnoughSpace4LayoutPage(OutputPage outputPage) {
        int n = 0;
        int n2 = this.pageSet.size();
        for (int i = 0; i < n2; ++i) {
            OutputPage outputPage2 = this.pageSet.get(i);
            n += outputPage2.getPageHeight();
        }
        return outputPage.getPageHeight() <= this.getHeight() - n;
    }

    private OutputPage getFirstPage() {
        if (this.pageSet.size() > 0 && this.pageSet.get(0) != null) {
            return this.pageSet.get(0);
        }
        return null;
    }
}

