/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.g2dexport;

import com.bokesoft.yes.report.output.OutputBorder;
import com.bokesoft.yes.report.output.OutputColor;
import com.bokesoft.yes.report.output.OutputDisplay;
import com.bokesoft.yes.report.output.OutputEmbedChart;
import com.bokesoft.yes.report.output.OutputEmbedObject;
import com.bokesoft.yes.report.output.OutputEmbedText;
import com.bokesoft.yes.report.output.OutputFont;
import com.bokesoft.yes.report.print.IUnitTrans;
import com.bokesoft.yes.report.print.g2dexport.G2dBorderUtil;
import com.bokesoft.yes.report.print.g2dexport.G2dTransContext;
import com.bokesoft.yes.report.print.transform.IEmbedExport;
import com.bokesoft.yes.report.print.transform.ITransformContext;
import com.bokesoft.yes.report.print.transform.PrinterColor;
import com.bokesoft.yes.report.util.FontFactory;
import com.bokesoft.yes.report.util.ReportUtil;
import com.bokesoft.yigo.report.print.chart.ReportChartFactory;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class G2dEmbedExport
implements IEmbedExport<G2dTransContext> {
    private IUnitTrans unitTrans = null;

    public G2dEmbedExport(IUnitTrans iUnitTrans) {
        this.unitTrans = iUnitTrans;
    }

    @Override
    public void export(G2dTransContext g2dTransContext, OutputEmbedObject outputEmbedObject, int n, int n2, int n3, int n4) {
        switch (outputEmbedObject.getType()) {
            case 0: {
                this.exportText(g2dTransContext, (OutputEmbedText)outputEmbedObject, n, n2, n3, n4);
                return;
            }
            case 2: {
                this.exportChart(g2dTransContext, (OutputEmbedChart)outputEmbedObject, n, n2, n3, n4);
            }
        }
    }

    private void exportChart(G2dTransContext object, OutputEmbedChart outputEmbedChart, int n, int n2, int n3, int n4) {
        object = ((G2dTransContext)object).getG2d();
        ReportChartFactory.createChart(outputEmbedChart).draw((Graphics2D)object, (Rectangle2D)new Rectangle2D.Double(n, n2, n3, n4));
    }

    private void exportText(G2dTransContext object, OutputEmbedText outputEmbedText, int n, int n2, int n3, int n4) {
        if (!ReportUtil.isNeedOutput((ITransformContext)object, outputEmbedText)) {
            return;
        }
        Graphics2D graphics2D = ((G2dTransContext)object).getG2d();
        OutputDisplay outputDisplay = outputEmbedText.getDisplay();
        OutputBorder outputBorder = outputDisplay.getBorder();
        Object object2 = outputEmbedText.getBackColor();
        PrinterColor printerColor = null;
        if (object2 != null) {
            printerColor = new PrinterColor((OutputColor)object2);
        }
        if (printerColor != null) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(printerColor);
            graphics2D.fillRect(n + G2dBorderUtil.getStrokeWidth(outputBorder.getLeftStyle()), n2 + G2dBorderUtil.getStrokeWidth(outputBorder.getTopStyle()), n3 - G2dBorderUtil.getStrokeWidth(outputBorder.getLeftStyle()) - G2dBorderUtil.getStrokeWidth(outputBorder.getRightStyle()), n4 - G2dBorderUtil.getStrokeWidth(outputBorder.getTopStyle()) - G2dBorderUtil.getStrokeWidth(outputBorder.getBottomStyle()));
            graphics2D.setPaint((Paint)object2);
        }
        G2dBorderUtil.drawRectLines((G2dTransContext)object, n, n2, n3, n4, outputBorder);
        object2 = outputEmbedText.getText();
        if (object2 == null || ((String)object2).length() == 0) {
            return;
        }
        object = outputDisplay.getFont();
        int n5 = this.unitTrans.transFontSize(((OutputFont)object).getSize());
        object = FontFactory.getFont((OutputFont)object, n5);
        graphics2D.setFont((Font)object);
        object = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = ((FontMetrics)object).getStringBounds((String)object2, graphics2D);
        double d = rectangle2D.getHeight();
        double d2 = rectangle2D.getWidth();
        if (1 == outputDisplay.getHorizontalAlignment()) {
            n = (int)((double)n + ((double)n3 - d2) / 2.0);
            n3 = ((FontMetrics)object).getAscent();
            int n6 = ((FontMetrics)object).getDescent();
            n2 += (n4 - (n3 + n6)) / 2 + n3;
        } else if (0 == outputDisplay.getHorizontalAlignment()) {
            n2 = (int)((double)n2 + ((double)n4 + d) / 2.0);
        }
        OutputColor outputColor = outputEmbedText.getForeColor();
        PrinterColor printerColor2 = new PrinterColor(outputColor);
        graphics2D.setColor(printerColor2);
        graphics2D.drawString((String)object2, (float)n, (float)n2);
    }
}

