/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.g2dexport;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.report.output.OutputBorder;
import com.bokesoft.yes.report.output.OutputCell;
import com.bokesoft.yes.report.output.OutputColor;
import com.bokesoft.yes.report.output.OutputDisplay;
import com.bokesoft.yes.report.output.OutputFont;
import com.bokesoft.yes.report.output.OutputRow;
import com.bokesoft.yes.report.print.IUnitTrans;
import com.bokesoft.yes.report.print.g2dexport.G2dBorderUtil;
import com.bokesoft.yes.report.print.g2dexport.G2dTransContext;
import com.bokesoft.yes.report.print.g2dexport.MatrixToImageUtil;
import com.bokesoft.yes.report.print.g2dexport.TextRenderer;
import com.bokesoft.yes.report.print.transform.ICellExport;
import com.bokesoft.yes.report.print.transform.ITransformContext;
import com.bokesoft.yes.report.print.transform.PrinterColor;
import com.bokesoft.yes.report.util.FontFactory;
import com.bokesoft.yes.report.util.ReportUtil;
import com.bokesoft.yigo.report.delegate.IResourceResolver;
import com.google.zxing.BarcodeFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class G2dCellExport
implements ICellExport<G2dTransContext> {
    private IUnitTrans unitTrans = null;

    public G2dCellExport(IUnitTrans iUnitTrans) {
        this.unitTrans = iUnitTrans;
    }

    @Override
    public void export(G2dTransContext object, OutputRow object2, OutputCell outputCell, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        n3 += n;
        n4 += n2;
        object2 = ReportUtil.getPaddingByStr(outputCell.getPadding());
        n3 += object2[0];
        n4 += object2[1];
        n5 -= object2[0] + object2[2];
        n6 -= object2[1] + object2[3];
        object2 = ((G2dTransContext)object).getG2d();
        Object object3 = outputCell.getBackColor();
        Object object4 = ((Graphics2D)object2).getPaint();
        OutputDisplay outputDisplay = outputCell.getDisplay();
        OutputBorder outputBorder = outputDisplay.getBorder();
        if (object3 != null) {
            object3 = new PrinterColor((OutputColor)object3);
            ((Graphics2D)object2).setPaint((Paint)object3);
            if (!((G2dTransContext)object).isOnlyFillEmptyContent()) {
                int n9 = outputBorder == null ? 0 : G2dBorderUtil.getStrokeWidth(outputBorder.getLeftStyle());
                int n10 = outputBorder == null ? 0 : G2dBorderUtil.getStrokeWidth(outputBorder.getTopStyle());
                n8 = outputBorder == null ? 0 : G2dBorderUtil.getStrokeWidth(outputBorder.getRightStyle());
                n7 = outputBorder == null ? 0 : G2dBorderUtil.getStrokeWidth(outputBorder.getBottomStyle());
                ((Graphics)object2).fillRect(n3 + n9, n4 + n10, n5 - n9 - n8, n6 - n10 - n7);
            }
            ((Graphics2D)object2).setPaint((Paint)object4);
        }
        if (!((G2dTransContext)object).isOnlyFillEmptyContent() && outputBorder != null) {
            G2dBorderUtil.drawRectLines((G2dTransContext)object, n3, n4, n5, n6, outputBorder);
        }
        boolean bl = ReportUtil.isNeedOutput((ITransformContext)object, outputCell);
        if (outputCell.getType() == 1) {
            this.drawImage((G2dTransContext)object, outputCell, n3, n4, n5, n6, bl);
            return;
        }
        String string = outputCell.getText();
        if (string == null) {
            return;
        }
        if (!StringUtil.isBlankOrNull((String)outputCell.getShowType())) {
            try {
                if (bl) {
                    if (BarcodeFormat.QR_CODE == BarcodeFormat.valueOf((String)outputCell.getShowType())) {
                        int n11 = n8 = Math.min(n5, n6);
                        BufferedImage bufferedImage = MatrixToImageUtil.text2Barcode(string, n11, n11, outputCell.getShowType(), outputCell.getEncodingType(), outputCell.getErrorCorrectionLevel(), outputCell.getMargin());
                        if (n8 == n6) {
                            switch (outputDisplay.getHorizontalAlignment()) {
                                case 2: {
                                    n3 += n5 - n6;
                                    break;
                                }
                                case 1: {
                                    n3 += (n5 - n6) / 2;
                                }
                            }
                        } else {
                            switch (outputDisplay.getVerticalAlignment()) {
                                case 3: {
                                    n3 += n6 - n5;
                                    break;
                                }
                                case 1: {
                                    n3 += (n5 - n6) / 2;
                                }
                            }
                        }
                        int n12 = n8;
                        ((Graphics)object2).drawImage(bufferedImage, n3, n4, n12, n12, null);
                        return;
                    }
                    BufferedImage bufferedImage = MatrixToImageUtil.text2Barcode(string, n5, n6, outputCell.getShowType(), outputCell.getEncodingType(), outputCell.getErrorCorrectionLevel(), outputCell.getMargin());
                    ((Graphics)object2).drawImage(bufferedImage, n3, n4, n5, n6, null);
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (string.length() == 0) {
            return;
        }
        OutputFont outputFont = outputDisplay.getFont();
        n7 = this.unitTrans.transFontSize(outputFont.getSize());
        object = FontFactory.getFont(outputFont, n7);
        object4 = outputCell.getForeColor();
        object4 = new PrinterColor((OutputColor)object4);
        ((Graphics)object2).setColor((Color)object4);
        int n13 = 3;
        int n14 = 3;
        switch (outputDisplay.getHorizontalAlignment()) {
            case 0: {
                n13 = 1;
                break;
            }
            case 1: {
                n13 = 3;
                break;
            }
            case 2: {
                n13 = 2;
            }
        }
        switch (outputDisplay.getVerticalAlignment()) {
            case 0: {
                n14 = 1;
                break;
            }
            case 1: {
                n14 = 3;
                break;
            }
            case 3: {
                n14 = 2;
            }
        }
        if (bl) {
            switch (outputCell.getOverflowType()) {
                case 2: {
                    TextRenderer.drawMultiLineTextEx((Graphics)object2, (Font)object, string, n3, n4, n5, n6, n13, n14, outputCell.isNeedUseDeviationSize());
                    return;
                }
                case 1: {
                    TextRenderer.drawMultiLineTextEx((Graphics)object2, (Font)object, string, n3, n4, n5, n6, n13, n14, outputCell.isNeedUseDeviationSize());
                    return;
                }
                case 3: {
                    TextRenderer.drawMultiLineTextEx((Graphics)object2, (Font)object, string, n3, n4, n5, n6, n13, n14, outputCell.isNeedUseDeviationSize());
                    return;
                }
            }
            TextRenderer.drawSimpleLineText((Graphics)object2, (Font)object, string, n3, n4, n5, n6, n13, n14);
        }
    }

    private void drawImage(G2dTransContext object, OutputCell outputCell, int n, int n2, int n3, int n4, boolean bl) {
        String string;
        Graphics2D graphics2D = ((G2dTransContext)object).getG2d();
        object = ((G2dTransContext)object).getResourceResolver();
        int n5 = outputCell.getImageSourceType();
        Image image = null;
        if (n5 == 2) {
            string = outputCell.getImageURL();
            if (string != null && string.length() > 0 && bl) {
                image = this.loadImage((IResourceResolver)object, string, n5);
            }
        } else if (n5 == 1) {
            string = outputCell.getText();
            image = this.loadImage((IResourceResolver)object, string, outputCell.getImageSourceType());
        }
        if (image != null) {
            int n6 = outputCell.getImageScaleType();
            int n7 = image.getWidth(null);
            int n8 = image.getHeight(null);
            bl = n7 > n3;
            int n9 = n5 = n8 > n4 ? 1 : 0;
            if (n6 == 0) {
                n6 = n + (n3 - n7) / 2;
                int n10 = n2 + (n4 - n8) / 2;
                int n11 = n + (n3 + n7) / 2;
                int n12 = n2 + (n4 + n8) / 2;
                int n13 = bl ? n : n6;
                int n14 = n5 != 0 ? n2 : n10;
                n11 = bl ? n + n3 : n11;
                n12 = n5 != 0 ? n2 + n4 : n12;
                n = bl ? n - n6 : 0;
                n2 = n5 != 0 ? n2 - n10 : 0;
                n7 = bl ? n + n3 : n7;
                n8 = n5 != 0 ? n2 + n4 : n8;
                graphics2D.drawImage(image, n13, n14, n11, n12, n, n2, n7, n8, null);
                return;
            }
            if (n6 == 6) {
                n6 = bl ? n + n3 : n + n7;
                int n15 = n5 != 0 ? n2 + n4 : n2 + n8;
                int n16 = bl ? n3 : n7;
                int n17 = n5 != 0 ? n4 : n8;
                graphics2D.drawImage(image, n, n2, n6, n15, 0, 0, n16, n17, null);
                return;
            }
            graphics2D.drawImage(image, n, n2, n3, n4, null);
        }
    }

    private Image loadImage(IResourceResolver object, String object2, int n) {
        if (StringUtil.isBlankOrNull((String)object2)) {
            return null;
        }
        object = n == 1 ? object.loadDataResource((String)object2) : object.loadResource((String)object2);
        if (object == null) {
            return null;
        }
        object2 = null;
        try {
            object2 = ImageIO.read((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object2;
    }
}

