/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.deparseformula;

import com.bokesoft.yes.deparseformula.FormulaDeparser;
import com.bokesoft.yes.deparseformula.FormulaDeparserWithFormat;
import com.bokesoft.yes.deparseformula.FormulaFormat;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class FormulaUtil {
    public static boolean isSetValueFunction(Item item) {
        return FormulaUtil.isSetValueFunctionSimple(item) || FormulaUtil.isSetValueFunctionIf(item) || FormulaUtil.isSetValueFunctionPreIIF(item) || FormulaUtil.isSetValueFunctionPreIIF2(item);
    }

    private static boolean isSetValueFunctionSimple(Item item) {
        if (item.getRule().getIndex() != 19 || !item.getFactor(0).getFullLexValue().equalsIgnoreCase("setValue")) {
            return false;
        }
        if (item.getFactor(2).getRule().getIndex() != 17) {
            return false;
        }
        return item.getChildCount() >= 6;
    }

    private static boolean isSetValueFunctionIf(Item item) {
        int n2 = item.getRule().getIndex();
        if (n2 == 26 || n2 == 28) {
            Item item2 = item.getFactor(5);
            return FormulaUtil.isSetValueFunctionSimple(item2.getRule().getIndex() == 0 ? item2.getFactor(0) : item2);
        }
        if (n2 == 27) {
            Item item3 = item.getFactor(5);
            if (!FormulaUtil.isSetValueFunctionSimple(item3.getRule().getIndex() == 0 ? item3.getFactor(0) : item3)) {
                return false;
            }
            return ((item = item.getFactor(9)).getRule().getIndex() == 0 ? item.getFactor(0) : item).getRule().getIndex() == 17;
        }
        return false;
    }

    private static boolean isSetValueFunctionPreIIF(Item item) {
        if (item.getRule().getIndex() != 19 || !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIF") && !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIFS")) {
            return false;
        }
        if (!FormulaUtil.isSetValueFunctionSimple(item.getFactor(4))) {
            return false;
        }
        return item.getChildCount() <= 8;
    }

    private static boolean isSetValueFunctionPreIIF2(Item item) {
        if (item.getRule().getIndex() != 19 || !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIF")) {
            return false;
        }
        if (item.getFactor(4).getRule().getIndex() != 17) {
            return false;
        }
        return FormulaUtil.isSetValueFunctionSimple(item.getFactor(6));
    }

    public static String getSetValueFieldKey(Item item) {
        if (FormulaUtil.isSetValueFunctionSimple(item)) {
            return item.getFactor(2).getFactor(0).getLexValue();
        }
        if (FormulaUtil.isSetValueFunctionIf(item)) {
            return ((item = item.getFactor(5)).getRule().getIndex() == 0 ? item.getFactor(0) : item).getFactor(2).getFactor(0).getLexValue();
        }
        if (FormulaUtil.isSetValueFunctionPreIIF(item)) {
            return item.getFactor(4).getFactor(2).getFactor(0).getLexValue();
        }
        if (FormulaUtil.isSetValueFunctionPreIIF2(item)) {
            return item.getFactor(6).getFactor(2).getFactor(0).getLexValue();
        }
        throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0cisSetValueFunction()\u4e3aFalse\u3002");
    }

    public static String getSetValueFormula(Item item) {
        if (FormulaUtil.isSetValueFunctionSimple(item)) {
            return FormulaDeparser.deParse(item.getFactor(4));
        }
        if (FormulaUtil.isSetValueFunctionIf(item)) {
            Item item2 = item.getFactor(5);
            item2 = item2.getRule().getIndex() == 0 ? item2.getFactor(0) : item2;
            return "IIF(" + FormulaDeparser.deParse(item.getFactor(2)) + ", " + FormulaDeparser.deParse(item2.getFactor(4)) + ", " + FormulaUtil.getSetValueFieldKey(item) + ")";
        }
        if (FormulaUtil.isSetValueFunctionPreIIF(item)) {
            return "IIF(" + FormulaDeparser.deParse(item.getFactor(2)) + ", " + FormulaDeparser.deParse(item.getFactor(4).getFactor(4)) + ", " + FormulaUtil.getSetValueFieldKey(item) + ")";
        }
        if (FormulaUtil.isSetValueFunctionPreIIF2(item)) {
            return "IIF(!(" + FormulaDeparser.deParse(item.getFactor(2)) + "), " + FormulaDeparser.deParse(item.getFactor(6).getFactor(4)) + ", " + FormulaUtil.getSetValueFieldKey(item) + ")";
        }
        throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0cisSetValueFunction()\u4e3aFalse\u3002");
    }

    public static boolean getSetValueIsValueChanged(Item item) {
        if (FormulaUtil.isSetValueFunctionSimple(item)) {
            if (item.getChildCount() < 7) {
                return false;
            }
            return TypeConvertor.toBoolean((Object)item.getFactor(6).getFactor(0).getLexValue());
        }
        if (FormulaUtil.isSetValueFunctionIf(item)) {
            if ((item = (item = item.getFactor(5)).getRule().getIndex() == 0 ? item.getFactor(0) : item).getChildCount() < 7) {
                return false;
            }
            return TypeConvertor.toBoolean((Object)item.getFactor(6).getFactor(0).getLexValue());
        }
        if (FormulaUtil.isSetValueFunctionPreIIF(item)) {
            if ((item = item.getFactor(4)).getChildCount() < 7) {
                return false;
            }
            return TypeConvertor.toBoolean((Object)item.getFactor(6).getFactor(0).getLexValue());
        }
        if (FormulaUtil.isSetValueFunctionPreIIF2(item)) {
            if ((item = item.getFactor(6)).getChildCount() < 7) {
                return false;
            }
            return TypeConvertor.toBoolean((Object)item.getFactor(6).getFactor(0).getLexValue());
        }
        throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0cisSetValueFunction()\u4e3aFalse\u3002");
    }

    public static List<Item> getStatements(Item item) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        if (item.getRule().getIndex() == 1) {
            int n2 = item.getChildCount();
            for (int i2 = 0; i2 < n2; i2 += 2) {
                arrayList.add(item.getFactor(i2));
            }
        } else {
            arrayList.add(item);
        }
        return arrayList;
    }

    public static String addDefaultFormulaValue(Item item, String string, String string2, String string3, String string4, String string5, Stack<String> stack) {
        if (FormulaUtil.isCheckRuleEmpty(string2)) {
            if (FormulaUtil.isEmpty(string4)) {
                throw new RuntimeException(FormulaDeparser.deParse(item) + "\u8f6c\u5316\u4e3a\u9ed8\u8ba4\u503c\u4e0d\u5bf9\uff0c\u89e6\u53d1\u5b57\u6bb5\u7684\u68c0\u67e5\u548c\u76ee\u6807\u5b57\u6bb5\u7684\u539f\u9ed8\u8ba4\u503c\u90fd\u4e3a\u7a7a\u3002" + stack.toString());
            }
            if (FormulaUtil.getSetValueIsValueChanged(item) && !FormulaUtil.isEmpty(string5)) {
                return null;
            }
            return FormulaDeparser.deParse(item);
        }
        if (string2.length() > 30) {
            return "IIF(isCheck('" + string + "'), " + FormulaDeparser.deParse(item) + ", " + string3 + ")";
        }
        return "IIF(" + string2 + ", " + FormulaDeparser.deParse(item) + ", " + string3 + ")";
    }

    private static boolean isCheckRuleEmpty(String string) {
        return string == null || string.length() == 0 || string.equalsIgnoreCase("true");
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void main(String[] object) {
        object = "setValue('AA', 1+ 2, true)";
        Parser object22 = new Parser(null);
        object = object22.parse((String)object);
        System.out.println(FormulaUtil.isSetValueFunction(((SyntaxTree)object).getRoot()));
        object = "setValue('AA', 1+ 2, true);Hi( 1+2);SEtValue('BB', 2);SEtValue('BB', 2, false)";
        object = object22.parse((String)object);
        System.out.println(FormulaDeparser.deParse(((SyntaxTree)object).getRoot()));
        for (Item item : FormulaUtil.getStatements(((SyntaxTree)object).getRoot())) {
            System.out.println(FormulaDeparser.deParse(item) + ":" + FormulaUtil.isSetValueFunction(item));
            if (!FormulaUtil.isSetValueFunction(item)) continue;
            System.out.println(FormulaUtil.getSetValueIsValueChanged(item));
        }
    }

    public static String format(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        SyntaxTree syntaxTree = new Parser(null).parse(string);
        if (syntaxTree == null) {
            return string;
        }
        return FormulaDeparser.deParse(syntaxTree.getRoot());
    }

    public static boolean isSame(String object, String object2) {
        Parser parser;
        if (((String)object).equals(object2)) {
            return true;
        }
        if (object == null || ((String)object).length() == 0) {
            if (object2 == null || ((String)object2).length() == 0) {
                return true;
            }
        } else if (object2 == null || ((String)object2).length() == 0) {
            return false;
        }
        if ((object = (parser = new Parser(null)).parse((String)object)) == (object2 = parser.parse((String)object2))) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return FormulaUtil.isSame(((SyntaxTree)object).getRoot(), ((SyntaxTree)object2).getRoot());
    }

    private static boolean isSame(Item item, Item item2) {
        int n2;
        if (item == item2) {
            return true;
        }
        if (item == null || item2 == null) {
            return false;
        }
        if (item.getRule() != item2.getRule() || !StringUtils.equals((CharSequence)item.getLexValue(), (CharSequence)item2.getLexValue()) || !StringUtils.equals((CharSequence)item.getFullLexValue(), (CharSequence)item2.getFullLexValue()) || item.getChildCount() != item2.getChildCount()) {
            return false;
        }
        Rule rule = item.getRule();
        if (rule != null && ((n2 = rule.getIndex()) == 2 || n2 == 4) && (FormulaUtil.isSame(item.getFactor(0), item2.getFactor(0)) && FormulaUtil.isSame(item.getFactor(2), item2.getFactor(2)) || FormulaUtil.isSame(item.getFactor(0), item2.getFactor(2)) && FormulaUtil.isSame(item.getFactor(2), item2.getFactor(0)))) {
            return true;
        }
        int n3 = item.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (FormulaUtil.isSame(item.getFactor(i2), item2.getFactor(i2))) continue;
            return false;
        }
        return true;
    }

    public static String deParseStatements(List<Item> list, FormulaFormat formulaFormat) {
        if (list.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(FormulaDeparserWithFormat.deParse(list.get(0), formulaFormat));
        int n2 = list.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(";").append(FormulaDeparserWithFormat.deParse(list.get(i2), formulaFormat));
        }
        return stringBuilder.toString();
    }

    public static List<Item> getLeafItems(Item item) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        return FormulaUtil.getLeafItems(item, arrayList);
    }

    private static List<Item> getLeafItems(Item object, List<Item> list) {
        if (((Item)object).getChildCount() == 0) {
            if (((Item)object).getLexValue() == ";" && ((Item)object).getFullLexValue() != null && ((Item)object).getFullLexValue().length() > 0) {
                return list;
            }
            list.add((Item)object);
        } else {
            object = ((Item)object).getAllChild().iterator();
            while (object.hasNext()) {
                FormulaUtil.getLeafItems((Item)object.next(), list);
            }
        }
        return list;
    }

    public static boolean isDependFieldKey(String object, String string) {
        for (Item item : FormulaUtil.getLeafItems(new Parser(null).parse((String)object).getRoot())) {
            if (!string.equals(item.getLexValue()) || !"id".equals(item.getRuleFactor().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCalcFormula(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return FormulaUtil.isCalcItem(new Parser(null).parse(string).getRoot());
    }

    private static boolean isCalcItem(Item object) {
        ArrayList<Item> arrayList;
        Rule rule = ((Item)object).getRule();
        if (rule == null) {
            return false;
        }
        int n2 = rule.getIndex();
        if (n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5) {
            return true;
        }
        if (n2 == 19) {
            String string = ((Item)object).getFactor(0).getLexValue();
            if (string.equalsIgnoreCase("GetDictOID") || string.equalsIgnoreCase("GetDictValue")) {
                return true;
            }
            if (string.startsWith("com.bokesoft.")) {
                return true;
            }
        }
        if ((arrayList = ((Item)object).getAllChild()) != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (!FormulaUtil.isCalcItem((Item)object.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasVarStatement(Item item) {
        Rule rule = item.getRule();
        if (rule == null) {
            return false;
        }
        int n2 = rule.getIndex();
        if (n2 == 0 || n2 == 1) {
            n2 = item.getChildCount();
            for (int i2 = 0; i2 < n2; i2 += 2) {
                if (!FormulaUtil.hasVarStatement(item.getFactor(i2))) continue;
                return true;
            }
        } else if (n2 == 25) {
            return true;
        }
        return false;
    }
}

