/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration;

import com.bokesoft.yes.common.util.CompareUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.datamigration.calculate.MetaMigrationParas;
import com.bokesoft.yes.mid.io.migration.MigrationDataProcess;
import com.bokesoft.yes.mid.migration.period.PeriodUtil;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.migration.IPeriodProcess;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class MigrationDataMergerImpl {
    private Document document;
    private MetaMigrationParas migrationParas;
    private DataTable primaryTable;
    private DataTable changeData;
    private DataTable currentData;
    private DataTable originalData;
    private MetaDataMigration metaMigration;
    private int dataOperateType = 2;
    private boolean newHeadResult = false;
    private boolean originalHeadResult = false;
    private IPeriodProcess dateProcess = null;
    private IPeriodProcess periodProcess = null;
    private MigrationDataProcess dataProcess = null;
    private boolean useOptimzation = true;
    private int oldStatus = 0;
    private int newStatus = 0;
    private static Boolean logEnable = null;

    public MigrationDataMergerImpl(DefaultContext object, Document document, MetaDataMigration metaDataMigration, boolean bl, boolean bl2) throws Throwable {
        MetaTable metaTable2;
        this.metaMigration = metaDataMigration;
        this.migrationParas = metaDataMigration.getMigrationParas(object.getVE().getMetaFactory());
        for (MetaTable metaTable2 : this.migrationParas.getSourceDataObject().getTableCollection()) {
            if (metaTable2.getTableMode() != 0) continue;
            document.get(metaTable2.getKey()).first();
        }
        this.document = document;
        this.useOptimzation = bl;
        this.primaryTable = document.get(this.migrationParas.getSrcPrimaryTableKey());
        if (bl2) {
            this.dataOperateType = 3;
        }
        this.periodProcess = this.dateProcess = new PeriodUtil();
        String string = this.migrationParas.getPeriodImpl();
        if (string != null && !string.isEmpty()) {
            this.periodProcess = (IPeriodProcess)ReflectHelper.newInstance((VE)object.getVE(), (String)string);
        }
        metaTable2 = document.get(this.migrationParas.getSrcMainTableKey());
        object = metaDataMigration.getStatusFieldKey();
        if (object == null || ((String)object).isEmpty()) {
            object = "Status";
        }
        if (this.migrationParas.getStatusIntValue() != null) {
            this.newStatus = TypeConvertor.toInteger((Object)metaTable2.getObject(0, (String)object));
        }
        if (document.isNew()) {
            this.dataOperateType = 1;
        } else if (this.migrationParas.getStatusIntValue() != null) {
            this.oldStatus = TypeConvertor.toInteger((Object)metaTable2.getOriginalObject(0, (String)object));
        }
        object = this.migrationParas.getTargetMetaTable();
        this.changeData = DataTableUtil.newEmptyDataTable((MetaTable)object);
        this.currentData = DataTableUtil.newEmptyDataTable((MetaTable)object);
        this.originalData = DataTableUtil.newEmptyDataTable((MetaTable)object);
        this.dataProcess = new MigrationDataProcess(this.migrationParas);
    }

    public DataTable getChangeData(DefaultContext defaultContext) throws Throwable {
        this.mapRow(defaultContext);
        return this.changeData;
    }

    private void mapRow(DefaultContext defaultContext) throws Throwable {
        this.newHeadResult = this.checkHeadCondition(defaultContext, false);
        this.originalHeadResult = this.checkHeadCondition(defaultContext, true);
        if (!this.newHeadResult && !this.originalHeadResult) {
            return;
        }
        this.primaryTable.beforeFirst();
        while (this.primaryTable.next()) {
            this.mapRow(defaultContext, this.dataProcess);
        }
        if (this.changeData.size() == 0) {
            return;
        }
        if (this.useOptimzation) {
            this.dataProcess.optimzationFilter(this.changeData);
        }
        if (this.changeData.size() == 0) {
            return;
        }
        this.logMigrationData(defaultContext, this.currentData, "currentData");
        this.logMigrationData(defaultContext, this.originalData, "originalData");
        this.logMigrationData(defaultContext, this.changeData, "changeData");
        this.dataProcess.mergeData(defaultContext, this.changeData);
    }

    private void logMigrationData(DefaultContext defaultContext, DataTable dataTable, String string) throws Throwable {
        try {
            if (logEnable == null) {
                String string2;
                MetaSimpleSetting metaSimpleSetting = defaultContext.getVE().getMetaFactory().getSetting().getSimpleSetting("MigrationDebug");
                logEnable = Boolean.FALSE;
                if (metaSimpleSetting != null && (string2 = metaSimpleSetting.get("Enable")) != null && !string2.isEmpty() && string2.equalsIgnoreCase("true")) {
                    logEnable = Boolean.TRUE;
                }
            }
            if (!logEnable.booleanValue()) {
                return;
            }
            LogSvr.getInstance().debug("........log..." + string + "..........");
            int n = dataTable.size();
            int n2 = dataTable.getMetaData().getColumnCount();
            LogSvr.getInstance().debug(" rowCount : ".concat(String.valueOf(n)));
            for (int i = 0; i < n; ++i) {
                LogSvr.getInstance().debug(" rowIndex : ".concat(String.valueOf(i)));
                for (int j = 0; j < n2; ++j) {
                    string = dataTable.getMetaData().getColumnInfo(j).getColumnKey();
                    Object object = dataTable.getObject(i, j);
                    LogSvr.getInstance().debug(" colKey : " + string + "\tvalue : " + object);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(" log data has error.", throwable);
            return;
        }
    }

    private void mapRow(DefaultContext defaultContext, MigrationDataProcess object) throws Throwable {
        DataTable dataTable;
        Serializable serializable = TypeConvertor.toLong((Object)this.primaryTable.getObject("POID"));
        for (String string : this.migrationParas.getParentTableList()) {
            boolean bl = false;
            Object object2 = this.document.get(string);
            object2.beforeFirst();
            while (object2.next()) {
                if (!TypeConvertor.toLong((Object)object2.getObject("OID")).equals(serializable)) continue;
                serializable = TypeConvertor.toLong((Object)object2.getObject("POID"));
                bl = true;
                break;
            }
            if (bl) continue;
            throw new MidCoreException(28, MidCoreException.formatMessage((ILocale)defaultContext.getEnv(), (int)28, (Object[])new Object[0]));
        }
        int n = object.getOperateType(defaultContext, this.metaMigration, this.primaryTable, this.dataOperateType, this.newHeadResult, this.originalHeadResult);
        if (n == -1) {
            return;
        }
        boolean bl = false;
        DocumentUtil.newRow((MetaTable)this.migrationParas.getTargetMetaTable(), (DataTable)this.currentData);
        DocumentUtil.newRow((MetaTable)this.migrationParas.getTargetMetaTable(), (DataTable)this.originalData);
        for (Object object2 : this.migrationParas.getHeadList()) {
            dataTable = this.document.get(object2.getTableKey());
            dataTable.first();
            bl = this.mapData(defaultContext, dataTable, (MetaDMSourceTable)object2, n) || bl;
        }
        serializable = TypeConvertor.toLong((Object)this.primaryTable.getObject("POID"));
        for (Object object2 : this.migrationParas.getParentTableList()) {
            dataTable = this.document.get((String)object2);
            if (!TypeConvertor.toLong((Object)dataTable.getObject("OID")).equals(serializable)) continue;
            TypeConvertor.toLong((Object)dataTable.getObject("POID"));
            serializable = (MetaDMSourceTable)this.metaMigration.getSourceTableCollection().get((String)object2);
            if (serializable == null) break;
            bl = this.mapData(defaultContext, dataTable, (MetaDMSourceTable)serializable, n) || bl;
            break;
        }
        bl = this.mapData(defaultContext, this.primaryTable, this.migrationParas.getPrimaryDMSourceTable(), n) || bl;
        block4: for (Object object2 : this.migrationParas.getRefTableMap().values()) {
            dataTable = (MetaDMSourceTable)this.metaMigration.getSourceTableCollection().get(object2.getTableKey());
            object = new ArrayList();
            serializable = new ArrayList();
            for (String string : object2.getKeySet().keySet()) {
                String string2 = (String)object2.getKeySet().get(string);
                ((ArrayList)object).add(this.primaryTable.getObject(string2));
                ((ArrayList)serializable).add(string);
            }
            DataTable dataTable2 = this.document.get(object2.getTableKey());
            dataTable2.beforeFirst();
            block6: while (dataTable2.next()) {
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    if (CompareUtil.compare((Object)dataTable2.getObject((String)((ArrayList)serializable).get(i)), ((ArrayList)object).get(i)) != 0) continue block6;
                }
                bl = this.mapData(defaultContext, dataTable2, (MetaDMSourceTable)dataTable, n) || bl;
                continue block4;
            }
        }
        this.mergeRow(n);
        if (!bl) {
            this.changeData.delete();
        }
    }

    private void mergeRow(int n) throws Throwable {
        Object object;
        Object object2;
        boolean bl = false;
        for (MetaColumn metaColumn : this.migrationParas.getGroupColumnList()) {
            object2 = this.currentData.getObject(metaColumn.getKey());
            if (CompareUtil.compare((Object)object2, (Object)(object = this.originalData.getObject(metaColumn.getKey()))) == 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            MigrationDataMergerImpl migrationDataMergerImpl = this;
            migrationDataMergerImpl.mergeChanged(migrationDataMergerImpl.originalData, true);
            MigrationDataMergerImpl migrationDataMergerImpl2 = this;
            migrationDataMergerImpl2.mergeChanged(migrationDataMergerImpl2.currentData, false);
            return;
        }
        DocumentUtil.newRow((MetaTable)this.migrationParas.getTargetMetaTable(), (DataTable)this.changeData);
        for (MetaColumn metaColumn : this.migrationParas.getGroupColumnList()) {
            object2 = this.currentData.getObject(metaColumn.getKey());
            this.changeData.setObject(metaColumn.getKey(), object2);
        }
        for (MetaColumn metaColumn : this.migrationParas.getDataColumnList()) {
            object2 = (MetaDMSourceField)this.migrationParas.getFieldMap().get(metaColumn.getKey());
            if (object2 == null) continue;
            object = null;
            Object object3 = this.currentData.getObject(metaColumn.getKey());
            Object object4 = this.originalData.getObject(metaColumn.getKey());
            if (n == 1) {
                object = object3;
            } else if (n == 2) {
                if (object2.getType() == 0 && object2.getOpSign() == 0) {
                    object = TypeConvertor.toBigDecimal((Object)object3).subtract(TypeConvertor.toBigDecimal((Object)object4));
                } else if (object2.getType() == 1 && object2.getOpSign() == 0) {
                    object = TypeConvertor.toBigDecimal((Object)object3).subtract(TypeConvertor.toBigDecimal((Object)object4));
                } else if (object2.getOpSign() == 2) {
                    object = object3;
                }
            } else if (n == 3) {
                object = object2.getOpSign() != 2 ? BigDecimal.ZERO.subtract(TypeConvertor.toBigDecimal((Object)object4)) : object4;
            }
            if (metaColumn.getDataType() == 1005) {
                object = TypeConvertor.toBigDecimal((Object)object, (Integer)metaColumn.getScale());
            }
            this.changeData.setObject(metaColumn.getKey(), object);
        }
    }

    private boolean mapData(DefaultContext defaultContext, DataTable dataTable, MetaDMSourceTable object, int n) throws Throwable {
        boolean bl = n != 2;
        MetaDMSourceField metaDMSourceField = null;
        Object object2 = null;
        Object object3 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object4;
            MetaDMSourceField metaDMSourceField2 = (MetaDMSourceField)object.next();
            Object object5 = null;
            int n2 = metaDMSourceField2.getDateGranularity();
            switch (metaDMSourceField2.getType()) {
                case 0: {
                    object5 = n == 3 ? dataTable.getOriginalObject(metaDMSourceField2.getDefinition()) : dataTable.getObject(metaDMSourceField2.getDefinition());
                    break;
                }
                case 2: {
                    object5 = metaDMSourceField2.getConstValue();
                    break;
                }
                case 1: {
                    if (n == 3) {
                        defaultContext.setOriginalValue(true);
                        object5 = defaultContext.getMidParser().eval(0, metaDMSourceField2.getDefinition(), (IEvalContext)defaultContext, null);
                        defaultContext.setOriginalValue(false);
                        break;
                    }
                    object5 = defaultContext.getMidParser().eval(0, metaDMSourceField2.getDefinition(), (IEvalContext)defaultContext, null);
                }
            }
            if (metaDMSourceField2.getGroupType() != -1) {
                object4 = this.dataProcess.getOriginalValue(defaultContext, dataTable, metaDMSourceField2, n, object5);
                if (metaDMSourceField2.getGroupType() == 1) {
                    metaDMSourceField = metaDMSourceField2;
                    object2 = object5;
                    object3 = object4;
                    continue;
                }
                if (metaDMSourceField2.isNeedTypeConvert()) {
                    object5 = TypeConvertor.toDataType((int)metaDMSourceField2.getTargetFieldDataType(), (Object)object5);
                    object4 = TypeConvertor.toDataType((int)metaDMSourceField2.getTargetFieldDataType(), (Object)object4);
                }
                object5 = this.getDateGranularityTypeValue(defaultContext, object5, n2, hashMap);
                object4 = this.getDateGranularityTypeValue(defaultContext, object4, n2, hashMap2);
                hashMap.put(metaDMSourceField2.getTargetFieldKey(), object5);
                hashMap2.put(metaDMSourceField2.getTargetFieldKey(), object4);
            } else {
                object4 = this.dataProcess.getOriginalValue(defaultContext, dataTable, metaDMSourceField2, n, object5);
                if (n == 3 && metaDMSourceField2.getOpSign() != 2) {
                    object5 = BigDecimal.ZERO;
                }
                if (metaDMSourceField2.isNeedTypeConvert()) {
                    object5 = TypeConvertor.toDataType((int)metaDMSourceField2.getTargetFieldDataType(), (Object)object5);
                    object4 = TypeConvertor.toDataType((int)metaDMSourceField2.getTargetFieldDataType(), (Object)object4);
                }
                object5 = this.getDateGranularityTypeValue(defaultContext, object5, n2, hashMap);
                object4 = this.getDateGranularityTypeValue(defaultContext, object4, n2, hashMap2);
            }
            if (!bl) {
                bl = CompareUtil.compare((Object)object5, (Object)object4) != 0;
            }
            this.originalData.setObject(metaDMSourceField2.getTargetFieldKey(), object4);
            this.currentData.setObject(metaDMSourceField2.getTargetFieldKey(), object5);
        }
        if (metaDMSourceField != null) {
            int n3 = metaDMSourceField.getPeriodValue();
            if (n3 == 0) {
                if (object2 != null) {
                    object2 = this.periodProcess.getPeriodValue(defaultContext, TypeConvertor.toDate(object2), this.migrationParas.getPeriodGranularity(), hashMap);
                }
                if (object3 != null) {
                    object3 = this.periodProcess.getPeriodValue(defaultContext, TypeConvertor.toDate(object3), this.migrationParas.getPeriodGranularity(), hashMap2);
                }
            } else if (n3 == 2) {
                object2 = defaultContext.getMidParser().eval(0, metaDMSourceField.getMapFormula(), (IEvalContext)defaultContext, null);
                if (n == 2) {
                    defaultContext.setOriginalValue(true);
                    object3 = defaultContext.getMidParser().eval(0, metaDMSourceField.getMapFormula(), (IEvalContext)defaultContext, null);
                    defaultContext.setOriginalValue(false);
                } else {
                    object3 = object2;
                }
            }
            if (metaDMSourceField.isNeedTypeConvert()) {
                object2 = TypeConvertor.toDataType((int)metaDMSourceField.getTargetFieldDataType(), object2);
                object3 = TypeConvertor.toDataType((int)metaDMSourceField.getTargetFieldDataType(), (Object)object3);
            }
            if (!bl) {
                bl = CompareUtil.compare((Object)object2, object3) != 0;
            }
            this.currentData.setObject(metaDMSourceField.getTargetFieldKey(), object2);
            this.originalData.setObject(metaDMSourceField.getTargetFieldKey(), object3);
        }
        return bl;
    }

    private void mergeChanged(DataTable dataTable, boolean bl) throws Throwable {
        Object object;
        DocumentUtil.newRow((MetaTable)this.migrationParas.getTargetMetaTable(), (DataTable)this.changeData);
        for (MetaColumn metaColumn : this.migrationParas.getGroupColumnList()) {
            object = dataTable.getObject(metaColumn.getKey());
            this.changeData.setObject(metaColumn.getKey(), object);
        }
        for (MetaColumn metaColumn : this.migrationParas.getDataColumnList()) {
            object = (MetaDMSourceField)this.migrationParas.getFieldMap().get(metaColumn.getKey());
            if (object == null) continue;
            Object object2 = dataTable.getObject(metaColumn.getKey());
            object = bl ? (object.getOpSign() != 2 ? BigDecimal.ZERO.subtract(TypeConvertor.toBigDecimal((Object)object2)) : object2) : object2;
            this.changeData.setObject(metaColumn.getKey(), object);
        }
    }

    private Object getDateGranularityTypeValue(DefaultContext defaultContext, Object object, int n, HashMap<String, Object> hashMap) throws Throwable {
        Object object2 = object;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                object2 = this.dateProcess.getPeriodValue(defaultContext, TypeConvertor.toDate((Object)object), n, hashMap);
                break;
            }
            case 3: {
                object2 = this.periodProcess.getPeriodValue(defaultContext, TypeConvertor.toDate((Object)object), n, hashMap);
            }
        }
        return object2;
    }

    private boolean checkHeadCondition(DefaultContext defaultContext, boolean bl) throws Throwable {
        boolean bl2 = true;
        if (this.migrationParas.getStatusIntValue() != null) {
            bl2 = bl ? this.oldStatus >= this.migrationParas.getStatusIntValue() : this.newStatus >= this.migrationParas.getStatusIntValue();
        }
        String string = this.metaMigration.getHeadCondition();
        if (bl2 && string != null && !string.trim().isEmpty()) {
            defaultContext.setOriginalValue(bl);
            bl2 = TypeConvertor.toBoolean((Object)defaultContext.getMidParser().eval(0, string, (IEvalContext)defaultContext, null)) != false;
            defaultContext.setOriginalValue(false);
        }
        return bl2;
    }
}

