/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.transformer;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yes.excel.transformer.ExcelDefaultDataTransformer;
import com.bokesoft.yes.excel.transformer.ExcelDictDataTransformer;
import com.bokesoft.yes.excel.transformer.ExcelListDataTransformer;
import com.bokesoft.yes.excel.transformer.IExcelTransformer;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.HashMap;

public class ExcelTransformerFactory {
    private static ExcelDefaultDataTransformer DEFAULT_TRANSFORMER = new ExcelDefaultDataTransformer();
    private HashMap<String, IExcelTransformer> transMap = new HashMap();

    public IExcelTransformer getTransformer(VE vE, ExcelCell object) {
        String string = ((ExcelCell)object).getDefinition();
        if (string != null && !string.isEmpty() && (object = ((ExcelCell)object).getDisplay()) != null && (object = ((ExcelDisplay)object).getFormat()) != null) {
            return this.getTransformer(vE, string, ((ExcelFormat)object).getDataType());
        }
        return DEFAULT_TRANSFORMER;
    }

    public IExcelTransformer getTransformer(VE vE, String string, int n) {
        if (!StringUtil.isBlankOrNull((String)string)) {
            IExcelTransformer iExcelTransformer = this.transMap.get(string = this.getKeyWithType(string, n));
            if (iExcelTransformer == null) {
                switch (n) {
                    case 1: {
                        iExcelTransformer = new ExcelDictDataTransformer(vE);
                        break;
                    }
                    case 3: 
                    case 4: {
                        iExcelTransformer = new ExcelListDataTransformer();
                        break;
                    }
                    default: {
                        iExcelTransformer = new ExcelDefaultDataTransformer();
                    }
                }
                this.transMap.put(string, iExcelTransformer);
            }
            return iExcelTransformer;
        }
        return DEFAULT_TRANSFORMER;
    }

    private String getKeyWithType(String string, int n) {
        return string + "|" + n;
    }
}

