/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.process.action;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutRow;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.template.ExcelListItem;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateFieldFormat;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;

public class InputRowAction
implements IInputRowAction {
    @Override
    public void doAction(int n, IInTable iInTable, OutTable object, ExcelTemplateTable excelTemplateTable, ExcelProcessContext excelProcessContext) throws Throwable {
        if (object == null) {
            return;
        }
        if (excelTemplateTable.isDtlTable() && iInTable.isEmptySheetRow(excelTemplateTable.getSheetName(), n)) {
            return;
        }
        object = ((OutTable)object).addRow();
        for (ExcelTemplateField excelTemplateField : excelTemplateTable.getFields()) {
            if (excelTemplateField.isIgnore4Import()) continue;
            if (excelProcessContext != null) {
                excelProcessContext.setCurTemplateField(excelTemplateField);
            }
            Object object2 = iInTable.getValue(excelTemplateTable.isDtlTable() && !excelTemplateField.isDimensionField() ? n : excelTemplateField.getRowIndex(), excelTemplateField.getColIndex(), excelProcessContext);
            object2 = this.transValue(object2, excelTemplateField, excelProcessContext);
            ((OutRow)object).setValue(excelTemplateField.getDefine(), object2);
        }
        if (excelProcessContext != null) {
            excelProcessContext.setCurTemplateField(null);
        }
    }

    private Object transValue(Object object, ExcelTemplateField excelTemplateField, ExcelProcessContext excelProcessContext) throws Throwable {
        ExcelTemplateFieldFormat excelTemplateFieldFormat = excelTemplateField.getFormat();
        MetaTable metaTable = excelProcessContext.getMetaDataObject().getTable(excelTemplateField.getTableKey());
        if (metaTable == null) {
            return object;
        }
        if ((metaTable = (MetaColumn)metaTable.get(excelTemplateField.getDefine())) == null) {
            return object;
        }
        switch (excelTemplateField.getFormat().getDataType()) {
            case 3: {
                return this.getListValue(object, excelTemplateFieldFormat.getListItems(), (MetaColumn)metaTable);
            }
            case 1: {
                if (!TypeConvertor.toString((Object)object).contains(",")) {
                    return this.getSingleDictValue(object, this.getDictShowFieldKey(excelTemplateFieldFormat.getFieldKeys()), excelTemplateFieldFormat.getItemKey(), excelProcessContext.getContext());
                }
                return this.getMultiDictValue(object, this.getDictShowFieldKey(excelTemplateFieldFormat.getFieldKeys()), excelTemplateFieldFormat.getItemKey(), excelProcessContext.getContext());
            }
            case 2: 
            case 5: {
                return this.getFormatValue(object, excelTemplateFieldFormat.getFormatString());
            }
            case 7: 
            case 8: {
                return object;
            }
        }
        return TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)metaTable.getDataType()), (Object)object);
    }

    private Object getFormatValue(Object object, String object2) throws ParseException {
        if (StringUtil.isBlankOrNull((String)object2)) {
            return object;
        }
        if (StringUtil.isBlankOrNull((Object)object)) {
            return null;
        }
        object2 = new DecimalFormat((String)object2);
        ((DecimalFormat)object2).setParseBigDecimal(true);
        return (BigDecimal)((NumberFormat)object2).parse(object.toString());
    }

    private Object getListValue(Object object, List<ExcelListItem> object2, MetaColumn metaColumn) {
        object2 = object2.iterator();
        while (object2.hasNext()) {
            ExcelListItem excelListItem = (ExcelListItem)object2.next();
            if (!TypeConvertor.toString((Object)excelListItem.getText()).equals(TypeConvertor.toString((Object)object))) continue;
            object = excelListItem.getValue();
        }
        return TypeConvertor.toJavaType((int)DBTypeUtil.dataType2JavaDataType((int)metaColumn.getDataType()), (Object)object);
    }

    private String getDictShowFieldKey(String string) {
        String string2 = string;
        if (StringUtil.instr((String)string, (String)",", (String)"")) {
            string2 = string.substring(0, string.indexOf(","));
        }
        return string2;
    }

    private Long getSingleDictValue(Object object, String string, String string2, DefaultContext defaultContext) throws Throwable {
        object = TypeConvertor.toString((Object)object);
        if ("Code".equalsIgnoreCase(string)) {
            object = ((String)object).toUpperCase();
        }
        if (!StringUtil.isBlankOrNull((String)object) && (object = defaultContext.getVE().getDictCache().locate(string2, string, object, null, null, 7, 0)) != null) {
            return object.getID();
        }
        return -1L;
    }

    private String getMultiDictValue(Object object, String string, String string2, DefaultContext defaultContext) throws Throwable {
        String[] stringArray = TypeConvertor.toString((Object)object);
        if (string.equals("Code")) {
            object.toString().toUpperCase();
        }
        if (!StringUtil.isBlankOrNull((String)stringArray)) {
            defaultContext = defaultContext.getVE().getDictCache();
            if (stringArray.contains(",")) {
                object = defaultContext.getAllItems(string2, null, 0, 0);
                stringArray = stringArray.split(",");
                if (object.size() == stringArray.length) {
                    return "0";
                }
                String string3 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    object = defaultContext.locate(string2, string, (Object)stringArray[i], null, null, 7, 0);
                    if (object == null) {
                        Long.valueOf(-1L);
                        continue;
                    }
                    object = object.getID();
                    string3 = i != 0 ? string3 + "," + object.toString() : object.toString();
                }
                return string3;
            }
        }
        return "";
    }
}

