/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.excel.template.ExcelBorder;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFont;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelStyleFactory {
    private Workbook workbook = null;
    private HashMap<String, CellStyle> styleMap = new HashMap();
    private CellStyle defaultStyle = null;

    public ExcelStyleFactory(Workbook workbook) {
        this.workbook = workbook;
        this.defaultStyle = workbook.createCellStyle();
        this.defaultStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.defaultStyle.setAlignment(HorizontalAlignment.CENTER);
        this.defaultStyle.setFont(this.createDefaultFont(workbook));
    }

    public CellStyle getCellStyle(ExcelCell object) {
        CellStyle cellStyle = null;
        if ((object = ((ExcelCell)object).getDisplay()) == null) {
            return this.defaultStyle;
        }
        String string = ((ExcelDisplay)object).createStyleKey();
        if (this.styleMap.containsKey(string)) {
            cellStyle = this.styleMap.get(string);
        }
        if (cellStyle == null) {
            String string2;
            cellStyle = this.workbook.createCellStyle();
            this.styleMap.put(string, cellStyle);
            cellStyle.setAlignment(this.tranExcelHAlignment(((ExcelDisplay)object).getHAlign()));
            cellStyle.setVerticalAlignment(this.tranExcelVAlignment(((ExcelDisplay)object).getVAlign()));
            cellStyle.setWrapText(((ExcelDisplay)object).isWrapText());
            ExcelStyleFactory excelStyleFactory = this;
            string = excelStyleFactory.createDefaultFont(excelStyleFactory.workbook);
            if (((ExcelDisplay)object).getFont() != null) {
                string = this.getExcelFont(((ExcelDisplay)object).getFont());
            }
            if (!(string2 = ((ExcelDisplay)object).getForeColor()).isEmpty()) {
                string.setColor(IndexedColors.valueOf((String)string2.toUpperCase()).index);
            }
            cellStyle.setFont((Font)string);
            string = ((ExcelDisplay)object).getBackColor();
            if (!string.isEmpty()) {
                cellStyle.setFillForegroundColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (((ExcelDisplay)object).getBorder() != null) {
                object = ((ExcelDisplay)object).getBorder();
                cellStyle.setBorderLeft(this.tranExcelBorder(((ExcelBorder)object).getLeftStyle()));
                cellStyle.setBorderTop(this.tranExcelBorder(((ExcelBorder)object).getTopStyle()));
                cellStyle.setBorderRight(this.tranExcelBorder(((ExcelBorder)object).getRightStyle()));
                cellStyle.setBorderBottom(this.tranExcelBorder(((ExcelBorder)object).getBottomStyle()));
                string = ((ExcelBorder)object).getLeftColor();
                if (!string.isEmpty()) {
                    cellStyle.setLeftBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
                if (!(string = ((ExcelBorder)object).getTopColor()).isEmpty()) {
                    cellStyle.setTopBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
                if (!(string = ((ExcelBorder)object).getRightColor()).isEmpty()) {
                    cellStyle.setRightBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
                if (!(string = ((ExcelBorder)object).getBottomColor()).isEmpty()) {
                    cellStyle.setBottomBorderColor(IndexedColors.valueOf((String)string.toUpperCase()).index);
                }
            }
        }
        return cellStyle;
    }

    private HorizontalAlignment tranExcelHAlignment(int n) {
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
        switch (n) {
            case 1: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case 0: {
                horizontalAlignment = HorizontalAlignment.LEFT;
                break;
            }
            case 2: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            }
        }
        return horizontalAlignment;
    }

    private VerticalAlignment tranExcelVAlignment(int n) {
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        switch (n) {
            case 1: {
                verticalAlignment = VerticalAlignment.CENTER;
                break;
            }
            case 2: {
                verticalAlignment = VerticalAlignment.BOTTOM;
                break;
            }
            case 0: {
                verticalAlignment = VerticalAlignment.TOP;
            }
        }
        return verticalAlignment;
    }

    private BorderStyle tranExcelBorder(int n) {
        BorderStyle borderStyle = BorderStyle.NONE;
        switch (n) {
            case 0: {
                borderStyle = BorderStyle.NONE;
                break;
            }
            case 1: {
                borderStyle = BorderStyle.DOUBLE;
                break;
            }
            case 2: {
                borderStyle = BorderStyle.THIN;
                break;
            }
            case 3: {
                borderStyle = BorderStyle.MEDIUM;
                break;
            }
            case 4: {
                borderStyle = BorderStyle.DASHED;
                break;
            }
            case 5: {
                borderStyle = BorderStyle.HAIR;
                break;
            }
            case 6: {
                borderStyle = BorderStyle.THICK;
            }
        }
        return borderStyle;
    }

    private Font getExcelFont(ExcelFont excelFont) {
        Font font = this.workbook.createFont();
        font.setBold(excelFont.isBold());
        font.setItalic(excelFont.isItalic());
        font.setFontName(excelFont.getName());
        font.setFontHeightInPoints(excelFont.getSize());
        return font;
    }

    private Font createDefaultFont(Workbook workbook) {
        workbook = workbook.createFont();
        workbook.setBold(false);
        workbook.setItalic(false);
        workbook.setFontName("\u5b8b\u4f53");
        workbook.setFontHeightInPoints((short)12);
        return workbook;
    }

    public CellStyle getDefaultStyle() {
        return this.defaultStyle;
    }
}

