/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.dee;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.dts.DataTransferService;
import com.bokesoft.yes.dts.data.DTSDataProvider;
import com.bokesoft.yes.dts.data.IDTSDataProvider;
import com.bokesoft.yes.dts.util.DTSUnZip;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.setting.MetaDTSProvider;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;

public class ImportDEEDataCmd
extends DefaultServiceCmd {
    private int transactionType;
    private String formKey;
    private String jsonString;
    private String providerKey;
    private boolean needUnzip = true;

    public ImportDEEDataCmd(int n, String string, String string2, String string3) {
        this.transactionType = n;
        this.formKey = string;
        this.jsonString = string2;
        this.providerKey = string3;
    }

    public ImportDEEDataCmd() {
    }

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.transactionType = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"transactionType"));
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"FormKey"));
        this.jsonString = TypeConvertor.toString((Object)stringHashMap.get((Object)"JsonString"));
        this.providerKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"providerKey"));
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        String string;
        Object object = defaultContext.getVE().getMetaFactory().getSetting().getDts();
        if (object == null) {
            LogSvr.getInstance().info("\u6ca1\u6709\u8bbe\u7f6eDTSProvider, \u4f7f\u7528\u9ed8\u8ba4\u7684provider");
            object = new DTSDataProvider();
        } else {
            if (this.providerKey.isEmpty() || this.providerKey == null) {
                this.providerKey = object.getDefaultProvider();
            }
            LogSvr.getInstance().info("providerKey: " + this.providerKey);
            string = (MetaDTSProvider)object.get(this.providerKey);
            if (string == null) {
                LogSvr.getInstance().info("\u627e\u4e0d\u5230DTSProvider, \u4f7f\u7528\u9ed8\u8ba4\u7684provider");
                object = new DTSDataProvider();
            } else {
                object = (IDTSDataProvider)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)string.getDriver());
            }
        }
        string = this.needUnzip ? DTSUnZip.getJsonString(this.jsonString) : this.jsonString;
        return DataTransferService.multiDataTransfer(defaultContext, (IDTSDataProvider)object, string, this.transactionType);
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ImportDEEDataCmd();
    }

    public String getCmd() {
        return "Import";
    }

    public void notUnzip() {
        this.needUnzip = false;
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

