/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.util;

import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.mid.session.SessionCacheFactory;
import java.util.ArrayList;
import java.util.List;

public class AuthUtil {
    private static ICache<String> simpleCache = SessionCacheFactory.getInstance().createCache("SimpleOperatorCache");
    private static ICache<String> mobileCache = SessionCacheFactory.getInstance().createCache("MobileOperatorCache");
    private static ICache<String> kickCache = SessionCacheFactory.getInstance().createCache("KickCache");
    private static ICache<String> operator4ClientIdCache = SessionCacheFactory.getInstance().createCache("Operator4ClientIdCache");

    public static void putLoginInfo(int n, long l, String string) {
        String string2 = AuthUtil.getKickKey(l);
        AuthUtil.getCache(n).put(string2, (Object)string);
    }

    public static String getLoginInfo(int n, long l) {
        String string = AuthUtil.getKickKey(l);
        return (String)AuthUtil.getCache(n).get(string);
    }

    public static void removeLoginInfo(int n, long l) {
        String string = AuthUtil.getKickKey(l);
        AuthUtil.getCache(n).remove(string);
    }

    public static boolean isKicked(String string) {
        return kickCache.contains(string);
    }

    public static void putKickInfo(String string, String string2) {
        kickCache.put(string, (Object)string2);
    }

    public static void putOperator4ClientIdCache(String string, String string2) {
        operator4ClientIdCache.put(string + "@" + string2, (Object)string2);
    }

    public static List<String> getOperatorClientIds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : operator4ClientIdCache.getKeys()) {
            if (!string2.startsWith(string + "@")) continue;
            string2 = (String)operator4ClientIdCache.get(string2);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static void removeOperatorClientID(String string, String string2) {
        operator4ClientIdCache.remove(string + "@" + string2);
    }

    public static void removeKickInfo(String string) {
        kickCache.remove(string);
    }

    private static String getKickKey(long l) {
        String string = CoreSetting.getInstance().getAppID();
        if (string == null || string.isEmpty()) {
            return String.valueOf(l);
        }
        return string + "&" + l;
    }

    private static ICache<String> getCache(int n) {
        ICache<String> iCache = null;
        switch (n) {
            case 1: {
                iCache = simpleCache;
                break;
            }
            case 2: {
                iCache = mobileCache;
            }
        }
        return iCache;
    }
}

