/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.session;

import com.bokesoft.yes.mid.rights.OperatorRightsUtil;
import com.bokesoft.yes.mid.session.AccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.mid.session.SysSessionLog;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AccountLockoutInfoMap
implements IAccountLockoutInfoMap {
    private ICache<IAccountLockoutInfo> accountLockMap = CacheFactory.getInstance().createCache("AccountLockoutCache");
    private int lockThreshold = 0;
    private int lockDuration = 0;
    private Boolean userLockInfoIsPersist = null;
    public static final String ACCOUNT_LOCKOUT_CACHE = "AccountLockoutCache";

    @Override
    public void setUserLockInfoIsPersist(Boolean bl) {
        this.userLockInfoIsPersist = bl;
    }

    public Boolean getUserLockInfoIsPersist() {
        return this.userLockInfoIsPersist;
    }

    public void put(String string, IAccountLockoutInfo iAccountLockoutInfo) {
        this.accountLockMap.put(string, (Object)iAccountLockoutInfo);
    }

    @Override
    public IAccountLockoutInfo get(String string) {
        return (IAccountLockoutInfo)this.accountLockMap.get(string);
    }

    @Override
    public void setAccountLockoutThreshold(int n) {
        this.lockThreshold = n;
    }

    @Override
    public int getAccountLockoutThreshold() {
        return this.lockThreshold;
    }

    @Override
    public void setAccountLockoutDuration(int n) {
        this.lockDuration = n;
    }

    @Override
    public void check(DefaultContext defaultContext, ISessionInfo iSessionInfo) throws SessionException {
        if (this.lockThreshold > 0) {
            long l = iSessionInfo.getOperatorID();
            int n = iSessionInfo.getMode();
            Object[] objectArray = (Object[])this.accountLockMap.get(l + "_" + n);
            if (objectArray != null) {
                if (objectArray.getLogin_failed_count() >= this.lockThreshold) {
                    if (this.lockDuration > 0) {
                        long l2;
                        long l3;
                        long l4 = new Date().getTime();
                        if (l4 - (l3 = objectArray.getLockDate().getTime()) < (l2 = (long)(this.lockDuration * 1000))) {
                            throw new SessionException(4, SessionException.formatMessage((ILocale)defaultContext.getEnv(), 4, new Object[0]));
                        }
                        return;
                    }
                    throw new SessionException(4, SessionException.formatMessage((ILocale)defaultContext.getEnv(), 4, new Object[0]));
                }
                return;
            }
            if (this.userLockInfoIsPersist.booleanValue()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = l;
                try {
                    DataTable dataTable = defaultContext.getDBManager().execPrepareQuery("select LockDateTime,Locked from  SYS_Operator where OID = ?", objectArray);
                    if (dataTable.size() > 0 && dataTable.getBoolean("Locked").booleanValue()) {
                        if (this.lockDuration > 0) {
                            long l5;
                            long l6;
                            long l7 = new Date().getTime();
                            Date date = dataTable.getDateTime("LockDateTime");
                            if (date != null && l7 - (l6 = date.getTime()) < (l5 = (long)(this.lockDuration * 1000))) {
                                throw new SessionException(4, SessionException.formatMessage((ILocale)defaultContext.getEnv(), 4, new Object[0]));
                            }
                            return;
                        }
                        throw new SessionException(4, SessionException.formatMessage((ILocale)defaultContext.getEnv(), 4, new Object[0]));
                    }
                    return;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.getMessage());
                }
            }
        }
    }

    @Override
    public void autoUnlock(DefaultContext defaultContext, ISessionInfo iSessionInfo) throws SessionException {
        if (this.lockThreshold > 0) {
            long l = iSessionInfo.getOperatorID();
            int n = iSessionInfo.getMode();
            DataTable dataTable = (DataTable)this.accountLockMap.get(l + "_" + n);
            if (dataTable != null) {
                long l2;
                long l3;
                long l4;
                if (dataTable.getLogin_failed_count() >= this.lockThreshold && this.lockDuration > 0 && (l4 = new Date().getTime()) - (l3 = dataTable.getLockDate().getTime()) >= (l2 = (long)(this.lockDuration * 1000))) {
                    this.autoUnlock(defaultContext, l, n);
                    new SysSessionLog().logUnlock(defaultContext, l, n);
                }
                return;
            }
            if (this.userLockInfoIsPersist.booleanValue()) {
                DataTable dataTable2 = new Object[1];
                dataTable = dataTable2;
                dataTable2[0] = l;
                try {
                    dataTable = defaultContext.getDBManager().execPrepareQuery("select LockDateTime,Locked from  SYS_Operator where OID = ?", (Object[])dataTable);
                    if (dataTable.size() > 0 && dataTable.getBoolean("Locked").booleanValue() && this.lockDuration > 0) {
                        long l5;
                        long l6;
                        long l7 = new Date().getTime();
                        Date date = dataTable.getDateTime("LockDateTime");
                        if (date != null && l7 - (l6 = date.getTime()) >= (l5 = (long)(this.lockDuration * 1000))) {
                            this.autoUnlock(defaultContext, l, n);
                            new SysSessionLog().logUnlock(defaultContext, l, n);
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.getMessage());
                }
            }
        }
    }

    @Override
    public int log(DefaultContext defaultContext, long l, int n, int n2) throws SessionException {
        int n3 = 0;
        String string = l + "_" + n;
        IAccountLockoutInfo iAccountLockoutInfo = (IAccountLockoutInfo)this.accountLockMap.get(string);
        if (this.lockThreshold > 0) {
            switch (n2) {
                case 1: {
                    if (iAccountLockoutInfo == null) {
                        iAccountLockoutInfo = new AccountLockoutInfo();
                    }
                    iAccountLockoutInfo.recordLoginFailed();
                    this.accountLockMap.put(string, (Object)iAccountLockoutInfo);
                    if (iAccountLockoutInfo.getLogin_failed_count() != this.lockThreshold) break;
                    this.autoLock(defaultContext, l, n, iAccountLockoutInfo);
                    new SysSessionLog().logLock(defaultContext, l, n);
                    break;
                }
                case 0: {
                    if (iAccountLockoutInfo != null) {
                        n3 = iAccountLockoutInfo.getLogin_failed_count();
                    }
                    this.accountLockMap.remove(l + "_" + n);
                }
            }
        }
        return n3;
    }

    @Override
    public boolean unlock(DefaultContext defaultContext, long l, Integer object) {
        object = l + "_" + object;
        if (this.accountLockMap.contains((String)object) || this.userLockInfoIsPersist.booleanValue()) {
            this.accountLockMap.remove((String)object);
            if (this.userLockInfoIsPersist.booleanValue()) {
                try {
                    if (OperatorRightsUtil.isAdmin(defaultContext)) {
                        Object[] objectArray = new Object[2];
                        object = objectArray;
                        objectArray[0] = "false";
                        object[1] = l;
                        defaultContext.getDBManager().execPrepareUpdate("update SYS_Operator set Locked = ? where OID = ?", object);
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public boolean autoUnlock(DefaultContext defaultContext, long l, Integer object) {
        object = l + "_" + object;
        if (this.accountLockMap.contains((String)object) || this.userLockInfoIsPersist.booleanValue()) {
            this.accountLockMap.remove((String)object);
            if (this.userLockInfoIsPersist.booleanValue()) {
                object = null;
                try {
                    Object[] objectArray = new Object[2];
                    object = defaultContext.newDBManager();
                    objectArray[0] = "false";
                    objectArray[1] = l;
                    object.execPrepareUpdate("update SYS_Operator set Locked = ? where OID = ?", objectArray);
                    object.commit();
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        try {
                            object.rollback();
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException.getMessage());
                        }
                    }
                    throw new RuntimeException(throwable.getMessage());
                }
                finally {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException.getMessage());
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean autoUnlocks(IDBManager iDBManager, long l) {
        try {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = "false";
            objectArray2[1] = l;
            iDBManager.execPrepareUpdate("update SYS_Operator set Locked = ? where OID = ?", objectArray2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        return true;
    }

    @Override
    public int lock(DefaultContext defaultContext, long l) {
        if (this.userLockInfoIsPersist.booleanValue()) {
            try {
                if (OperatorRightsUtil.isAdmin(defaultContext)) {
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = "true";
                    objectArray2[1] = new Date();
                    objectArray2[2] = l;
                    defaultContext.getDBManager().execPrepareUpdate("update SYS_Operator set Locked = ?, LockDateTime = ?  where OID = ?", objectArray2);
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void autoLock(DefaultContext objectArray, long l, int n, IAccountLockoutInfo iAccountLockoutInfo) {
        Object object = l + "_" + n;
        this.put((String)object, iAccountLockoutInfo);
        if (this.userLockInfoIsPersist == false) return;
        object = null;
        try {
            object = objectArray.newDBManager();
            Object[] objectArray2 = new Object[3];
            objectArray = objectArray2;
            objectArray2[0] = "true";
            objectArray[1] = new Date();
            objectArray[2] = l;
            object.execPrepareUpdate("update SYS_Operator set Locked = ?, LockDateTime = ?  where OID = ?", objectArray);
            object.commit();
            if (object == null) return;
        }
        catch (Throwable throwable) {
            try {
                if (object == null) throw new RuntimeException(throwable.getMessage());
                try {
                    object.rollback();
                    throw new RuntimeException(throwable.getMessage());
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage());
                }
            }
            catch (Throwable throwable2) {
                if (object == null) throw throwable2;
                try {
                    object.close();
                    throw throwable2;
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage());
                }
            }
        }
        try {
            object.close();
            return;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
    }

    @Override
    public Set<String> getKeys() {
        return this.accountLockMap.getKeys();
    }

    @Override
    public Map<String, IAccountLockoutInfo> updateAccountLockMap(DefaultContext object) {
        HashMap<String, IAccountLockoutInfo> hashMap = new HashMap<String, IAccountLockoutInfo>();
        Set set = this.accountLockMap.getKeys();
        if (set != null) {
            long l;
            long l2;
            long l3;
            IDBManager iDBManager = null;
            if (this.userLockInfoIsPersist.booleanValue()) {
                try {
                    iDBManager = ((BaseContext)object).newDBManager();
                    for (String string : set) {
                        int n;
                        IAccountLockoutInfo iAccountLockoutInfo = (IAccountLockoutInfo)this.accountLockMap.get(string);
                        if (iAccountLockoutInfo == null || iAccountLockoutInfo.getLogin_failed_count() < this.lockThreshold || this.lockDuration <= 0 || (l3 = new Date().getTime()) - (l2 = iAccountLockoutInfo.getLockDate().getTime()) < (l = (long)(this.lockDuration * 1000)) || (n = string.lastIndexOf("_")) <= 0) continue;
                        String string2 = string.substring(0, n);
                        this.autoUnlocks(iDBManager, Integer.valueOf(string2).intValue());
                    }
                    iDBManager.commit();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.getMessage());
                }
                finally {
                    if (iDBManager != null) {
                        try {
                            iDBManager.close();
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException.getMessage());
                        }
                    }
                }
            }
            for (String string : set) {
                object = (IAccountLockoutInfo)this.accountLockMap.get(string);
                if (object == null || object.getLogin_failed_count() < this.lockThreshold) continue;
                if (this.lockDuration > 0) {
                    l3 = new Date().getTime();
                    if (l3 - (l2 = object.getLockDate().getTime()) >= (l = (long)(this.lockDuration * 1000))) {
                        this.accountLockMap.remove(string);
                        continue;
                    }
                    hashMap.put(string, (IAccountLockoutInfo)object);
                    continue;
                }
                hashMap.put(string, (IAccountLockoutInfo)object);
            }
        }
        return hashMap;
    }
}

