/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.server.weight.recycle;

import com.bokesoft.yes.mid.server.weight.recycle.IRecycleable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ObjectRecycler {
    private static final ObjectRecycler instance = new ObjectRecycler();
    private ConcurrentHashMap<Class<?>, BlockingQueue<IRecycleable>> map = new ConcurrentHashMap();

    private ObjectRecycler() {
    }

    public <T> T newObject(Class<T> clazz) throws Throwable {
        Object e2 = this.ensurePool(clazz).poll();
        if (e2 == null) {
            return clazz.newInstance();
        }
        return (T)e2;
    }

    public void recycle(IRecycleable iRecycleable) {
        this.ensurePool(iRecycleable.getClass()).offer(iRecycleable);
    }

    private BlockingQueue<IRecycleable> ensurePool(Class<?> clazz) {
        BlockingQueue<IRecycleable> blockingQueue = this.map.get(clazz);
        if (blockingQueue == null) {
            blockingQueue = new LinkedBlockingQueue<IRecycleable>();
            this.map.put(clazz, blockingQueue);
        }
        return blockingQueue;
    }

    public static ObjectRecycler getInstance() {
        return instance;
    }
}

