/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.server.weight.config;

import com.bokesoft.pub.mid.dict.DictTreeNode;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.server.weight.config.AbstractWeightConfig;
import com.bokesoft.yes.mid.server.weight.config.a;
import com.bokesoft.yes.mid.server.weight.config.define.SqlTimeDefine;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.tools.wildcard.WildcardUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Element;

public class SqlTimeWeightConfig
extends AbstractWeightConfig {
    private static final String TAG_SqlTime = "SqlTime";
    private static final String TAG_Pattern = "Pattern";
    private static final String ATTR_Key = "Key";
    private static final String ATTR_Warn = "Warn";
    private static final String ATTR_Limit = "Limit";
    private boolean bLoading = false;
    private static final long DEFAULT_SQLTIME_WARN = 1000L;
    private static final long DEFAULT_SQLTIME_LIMIT = 20000L;
    private SqlTimeDefine initSqlTimeDefine;
    private SqlTimeDefine defaultSqlTimeDefine = this.initSqlTimeDefine = new SqlTimeDefine(1000L, 20000L);
    private long curLastModifiedTime;
    private long curLastSize;
    private WeakHashMap<String, SqlTimeDefine> tmpSqlTimeDefineCache = new WeakHashMap();
    private ConcurrentHashMap<String, SqlTimeDefine> mapSqlTimeDefine = new ConcurrentHashMap();

    private SqlTimeWeightConfig() {
        this.reload();
    }

    public void reload() {
        InputStream inputStream = PropertyUtil.getAllPropertiesFile("WeightConfig.xml");
        if (!this.bLoading && this.checkChanged(inputStream)) {
            this.doInit(inputStream);
        }
    }

    @Override
    public long getWarn(String string) {
        return this.matchSqlTimeDefine(string).getWarn();
    }

    @Override
    public long getLimit(String string) {
        return this.matchSqlTimeDefine(string).getLimit();
    }

    public SqlTimeDefine matchSqlTimeDefine(String string) {
        if (this.tmpSqlTimeDefineCache.containsKey(string)) {
            return this.tmpSqlTimeDefineCache.get(string);
        }
        if (this.mapSqlTimeDefine.containsKey(string)) {
            return this.mapSqlTimeDefine.get(string);
        }
        for (Map.Entry<String, SqlTimeDefine> entry : this.mapSqlTimeDefine.entrySet()) {
            if (!WildcardUtil.isMatch((String)string, (String)entry.getKey())) continue;
            this.tmpSqlTimeDefineCache.put(string, entry.getValue());
            return entry.getValue();
        }
        return this.defaultSqlTimeDefine;
    }

    private SqlTimeDefine createSqlTimeDefine(Element element) {
        long l = element.hasAttribute(ATTR_Warn) ? TypeConvertor.toLong((Object)element.getAttribute(ATTR_Warn)) : 1000L;
        long l2 = element.hasAttribute(ATTR_Limit) ? TypeConvertor.toLong((Object)element.getAttribute(ATTR_Limit)) : 20000L;
        return new SqlTimeDefine(l, l2);
    }

    private boolean checkChanged(InputStream inputStream) {
        try {
            if ((long)inputStream.available() == this.curLastSize) {
                return false;
            }
        }
        catch (IOException iOException) {
            LogSvr.getInstance().error(iOException.getMessage(), (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        return true;
    }

    private void doInit(InputStream object) {
        this.bLoading = true;
        this.mapSqlTimeDefine.clear();
        this.tmpSqlTimeDefineCache.clear();
        this.defaultSqlTimeDefine = this.initSqlTimeDefine;
        if (object != null) {
            try {
                this.curLastSize = ((InputStream)object).available();
                for (Element element : DomHelper.getChildList((Element)DomHelper.createDocument((InputStream)object).getDocumentElement())) {
                    if (!element.getTagName().equals(TAG_SqlTime)) continue;
                    this.defaultSqlTimeDefine = this.createSqlTimeDefine(element);
                    this.preparePatterns(element);
                }
                return;
            }
            catch (Throwable throwable) {
                LogSvr.getInstance().error(throwable.getMessage(), throwable);
                throwable.printStackTrace();
                return;
            }
            finally {
                this.bLoading = false;
            }
        }
    }

    private void preparePatterns(Element object) {
        for (Element element : DomHelper.getChildList((Element)((Object)object))) {
            if (!element.getTagName().equals(TAG_Pattern)) continue;
            SqlTimeDefine sqlTimeDefine = this.createSqlTimeDefine(element);
            String string = element.getAttribute(ATTR_Key);
            if (StringUtil.instr((String)string, (String)",", (String)"")) {
                for (String string2 : StringUtil.split((String)string, (String)",")) {
                    this.mapSqlTimeDefine.put(string2, sqlTimeDefine);
                }
                continue;
            }
            this.mapSqlTimeDefine.put(string, sqlTimeDefine);
        }
    }

    public static SqlTimeWeightConfig getInstance() {
        return a.a();
    }

    /* synthetic */ SqlTimeWeightConfig(DictTreeNode dictTreeNode) {
        this();
    }
}

