/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.server.weight.card;

import com.bokesoft.yes.mid.server.weight.card.type.EDeductionMode;
import com.bokesoft.yes.mid.server.weight.recycle.IRecycleable;

public abstract class AbstractWeightCard<T>
implements IRecycleable {
    protected volatile long balance = 0L;
    private volatile long warn = -1L;
    protected volatile long frozen = 0L;
    private volatile long cost = 0L;
    private String ticket;
    protected volatile EDeductionMode deductionModel = EDeductionMode.Normal;

    public void init(String string, long l, long l2) {
        this.ticket = string;
        this.balance = l;
        this.frozen = 0L;
        this.cost = 0L;
        this.warn = l2;
    }

    public void setWarnValue(long l) {
        this.warn = l;
    }

    public synchronized long consume(long l) throws Throwable {
        if (this.isZeroDeductionMode()) {
            return this.balance;
        }
        this.checkState();
        this.balance -= l;
        this.cost += l;
        return this.balance;
    }

    public synchronized void consume(long l, long l2) throws Throwable {
        if (this.isZeroDeductionMode()) {
            return;
        }
        this.frozen -= l2;
        this.consume(l);
    }

    public synchronized long frozen(long l) throws Throwable {
        if (this.isZeroDeductionMode()) {
            return 0L;
        }
        this.checkState();
        if (l > this.balance) {
            this.frozen += this.balance;
            return this.balance;
        }
        this.frozen += l;
        return l;
    }

    protected synchronized void checkState() throws Throwable {
        if (this.isZeroDeductionMode()) {
            return;
        }
        if (this.balance <= 0L) {
            this.fireBalanceNotEnoughError();
        }
    }

    protected synchronized void checkBalanceEnough(long l) throws Throwable {
        if (this.isZeroDeductionMode()) {
            return;
        }
        if (l > this.balance) {
            this.fireBalanceNotEnoughError();
        }
    }

    public synchronized long getBalance() {
        return this.balance;
    }

    public void setZeroDeductionMode() {
        this.deductionModel = EDeductionMode.ZeroDeduction;
    }

    public void setNormalDeductionMode() {
        this.deductionModel = EDeductionMode.Normal;
    }

    public boolean isWarnMode() {
        if (this.warn < 0L) {
            return false;
        }
        return this.cost > this.warn;
    }

    public long getTotalCosted() {
        return this.cost;
    }

    private boolean isZeroDeductionMode() {
        return this.deductionModel == EDeductionMode.ZeroDeduction;
    }

    public String getTicket() {
        return this.ticket;
    }

    protected abstract void fireBalanceNotEnoughError() throws Throwable;
}

